/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.logging;

import com.iterable.shade.javax.ws.rs.RuntimeType;
import com.iterable.shade.javax.ws.rs.core.Feature;
import com.iterable.shade.javax.ws.rs.core.FeatureContext;
import com.iterable.shade.org.glassfish.jersey.CommonProperties;
import com.iterable.shade.org.glassfish.jersey.logging.ClientLoggingFilter;
import com.iterable.shade.org.glassfish.jersey.logging.LoggingInterceptor;
import com.iterable.shade.org.glassfish.jersey.logging.ServerLoggingFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingFeature
implements Feature {
    public static final String DEFAULT_LOGGER_NAME = LoggingFeature.class.getName();
    public static final String DEFAULT_LOGGER_LEVEL = Level.FINE.getName();
    public static final int DEFAULT_MAX_ENTITY_SIZE = 8192;
    public static final Verbosity DEFAULT_VERBOSITY = Verbosity.PAYLOAD_TEXT;
    public static final String DEFAULT_SEPARATOR = "\n";
    public static final String DEFAULT_REDACT_HEADERS = "Authorization";
    private static final String LOGGER_NAME_POSTFIX = ".logger.name";
    private static final String LOGGER_LEVEL_POSTFIX = ".logger.level";
    private static final String VERBOSITY_POSTFIX = ".verbosity";
    private static final String MAX_ENTITY_POSTFIX = ".entity.maxSize";
    private static final String SEPARATOR_POSTFIX = ".separator";
    private static final String REDACT_HEADERS_POSTFIX = ".headers.redact";
    private static final String LOGGING_FEATURE_COMMON_PREFIX = "com.iterable.shade.jersey.config.logging";
    public static final String LOGGING_FEATURE_LOGGER_NAME = "com.iterable.shade.jersey.config.logging.logger.name";
    public static final String LOGGING_FEATURE_LOGGER_LEVEL = "com.iterable.shade.jersey.config.logging.logger.level";
    public static final String LOGGING_FEATURE_VERBOSITY = "com.iterable.shade.jersey.config.logging.verbosity";
    public static final String LOGGING_FEATURE_MAX_ENTITY_SIZE = "com.iterable.shade.jersey.config.logging.entity.maxSize";
    public static final String LOGGING_FEATURE_SEPARATOR = "com.iterable.shade.jersey.config.logging.separator";
    public static final String LOGGING_FEATURE_REDACT_HEADERS = "com.iterable.shade.jersey.config.logging.headers.redact";
    private static final String LOGGING_FEATURE_SERVER_PREFIX = "com.iterable.shade.jersey.config.server.logging";
    public static final String LOGGING_FEATURE_LOGGER_NAME_SERVER = "com.iterable.shade.jersey.config.server.logging.logger.name";
    public static final String LOGGING_FEATURE_LOGGER_LEVEL_SERVER = "com.iterable.shade.jersey.config.server.logging.logger.level";
    public static final String LOGGING_FEATURE_VERBOSITY_SERVER = "com.iterable.shade.jersey.config.server.logging.verbosity";
    public static final String LOGGING_FEATURE_MAX_ENTITY_SIZE_SERVER = "com.iterable.shade.jersey.config.server.logging.entity.maxSize";
    public static final String LOGGING_FEATURE_SEPARATOR_SERVER = "com.iterable.shade.jersey.config.server.logging.separator";
    public static final String LOGGING_FEATURE_REDACT_HEADERS_SERVER = "com.iterable.shade.jersey.config.server.logging.headers.redact";
    private static final String LOGGING_FEATURE_CLIENT_PREFIX = "com.iterable.shade.jersey.config.client.logging";
    public static final String LOGGING_FEATURE_LOGGER_NAME_CLIENT = "com.iterable.shade.jersey.config.client.logging.logger.name";
    public static final String LOGGING_FEATURE_LOGGER_LEVEL_CLIENT = "com.iterable.shade.jersey.config.client.logging.logger.level";
    public static final String LOGGING_FEATURE_VERBOSITY_CLIENT = "com.iterable.shade.jersey.config.client.logging.verbosity";
    public static final String LOGGING_FEATURE_MAX_ENTITY_SIZE_CLIENT = "com.iterable.shade.jersey.config.client.logging.entity.maxSize";
    public static final String LOGGING_FEATURE_SEPARATOR_CLIENT = "com.iterable.shade.jersey.config.client.logging.separator";
    public static final String LOGGING_FEATURE_REDACT_HEADERS_CLIENT = "com.iterable.shade.jersey.config.client.logging.headers.redact";
    private final LoggingFeatureBuilder builder;

    public LoggingFeature() {
        this(null, null, null, null);
    }

    public LoggingFeature(Logger logger) {
        this(logger, null, null, null);
    }

    public LoggingFeature(Logger logger, Verbosity verbosity) {
        this(logger, null, verbosity, null);
    }

    public LoggingFeature(Logger logger, Integer maxEntitySize) {
        this(logger, null, DEFAULT_VERBOSITY, maxEntitySize);
    }

    public LoggingFeature(Logger logger, Level level, Verbosity verbosity, Integer maxEntitySize) {
        this(LoggingFeature.builder().withLogger(logger).level(level).verbosity(verbosity).maxEntitySize(maxEntitySize));
    }

    public LoggingFeature(LoggingFeatureBuilder builder) {
        this.builder = builder;
    }

    @Override
    public boolean configure(FeatureContext context) {
        boolean enabled;
        boolean bl = enabled = context.getConfiguration().getRuntimeType() != null;
        if (enabled) {
            context.register(this.createLoggingFilter(context, context.getConfiguration().getRuntimeType()));
        }
        return enabled;
    }

    public static LoggingFeatureBuilder builder() {
        return new LoggingFeatureBuilder();
    }

    private LoggingInterceptor createLoggingFilter(FeatureContext context, RuntimeType runtimeType) {
        LoggingFeatureBuilder loggingBuilder = LoggingFeature.configureBuilderParameters(this.builder, context, runtimeType);
        return runtimeType == RuntimeType.SERVER ? new ServerLoggingFilter(loggingBuilder) : new ClientLoggingFilter(loggingBuilder);
    }

    private static LoggingFeatureBuilder configureBuilderParameters(LoggingFeatureBuilder builder, FeatureContext context, RuntimeType runtimeType) {
        Map<String, Object> properties = context.getConfiguration().getProperties();
        String filterLoggerName = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_LOGGER_NAME_SERVER : LOGGING_FEATURE_LOGGER_NAME_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_LOGGER_NAME, DEFAULT_LOGGER_NAME));
        String filterLevel = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_LOGGER_LEVEL_SERVER : LOGGING_FEATURE_LOGGER_LEVEL_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_LOGGER_LEVEL, DEFAULT_LOGGER_LEVEL));
        String filterSeparator = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_SEPARATOR_SERVER : LOGGING_FEATURE_SEPARATOR_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_SEPARATOR, DEFAULT_SEPARATOR));
        Verbosity filterVerbosity = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_VERBOSITY_SERVER : LOGGING_FEATURE_VERBOSITY_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_VERBOSITY, DEFAULT_VERBOSITY));
        int filterMaxEntitySize = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_MAX_ENTITY_SIZE_SERVER : LOGGING_FEATURE_MAX_ENTITY_SIZE_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_MAX_ENTITY_SIZE, 8192));
        String redactHeaders = CommonProperties.getValue(properties, runtimeType == RuntimeType.SERVER ? LOGGING_FEATURE_REDACT_HEADERS_SERVER : LOGGING_FEATURE_REDACT_HEADERS_CLIENT, CommonProperties.getValue(properties, LOGGING_FEATURE_REDACT_HEADERS, DEFAULT_REDACT_HEADERS));
        Level loggerLevel = Level.parse(filterLevel);
        builder.filterLogger = builder.filterLogger == null ? Logger.getLogger(filterLoggerName) : builder.filterLogger;
        builder.verbosity = builder.verbosity == null ? filterVerbosity : builder.verbosity;
        builder.maxEntitySize = builder.maxEntitySize == null ? filterMaxEntitySize : builder.maxEntitySize;
        builder.level = builder.level == null ? loggerLevel : builder.level;
        builder.separator = builder.separator == null ? filterSeparator : builder.separator;
        builder.redactHeaders = builder.redactHeaders == null ? Arrays.asList(redactHeaders.split(";")) : builder.redactHeaders;
        return builder;
    }

    public static class LoggingFeatureBuilder {
        Logger filterLogger;
        Verbosity verbosity;
        Integer maxEntitySize;
        Level level;
        String separator;
        Collection<String> redactHeaders;

        public LoggingFeatureBuilder withLogger(Logger logger) {
            this.filterLogger = logger;
            return this;
        }

        public LoggingFeatureBuilder verbosity(Verbosity verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public LoggingFeatureBuilder maxEntitySize(Integer maxEntitySize) {
            this.maxEntitySize = maxEntitySize;
            return this;
        }

        public LoggingFeatureBuilder level(Level level) {
            this.level = level;
            return this;
        }

        public LoggingFeatureBuilder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public LoggingFeatureBuilder redactHeaders(Collection<String> redactHeaders) {
            this.redactHeaders = redactHeaders;
            return this;
        }

        public LoggingFeature build() {
            return new LoggingFeature(this);
        }
    }

    public static enum Verbosity {
        HEADERS_ONLY,
        PAYLOAD_TEXT,
        PAYLOAD_ANY;

    }
}

