/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.internal;

import com.iterable.shade.javax.ws.rs.core.Configuration;
import com.iterable.shade.org.glassfish.jersey.internal.PropertiesDelegate;
import com.iterable.shade.org.glassfish.jersey.internal.util.PropertiesHelper;

public interface PropertiesResolver {
    public <T> T resolveProperty(String var1, Class<T> var2);

    public <T> T resolveProperty(String var1, T var2);

    public static PropertiesResolver create(final Configuration configuration, final PropertiesDelegate delegate) {
        return new PropertiesResolver(){

            @Override
            public <T> T resolveProperty(String name, Class<T> type) {
                return this.resolveProperty(name, null, type);
            }

            @Override
            public <T> T resolveProperty(String name, T defaultValue) {
                return (T)this.resolveProperty(name, defaultValue, defaultValue.getClass());
            }

            private <T> T resolveProperty(String name, Object defaultValue, Class<T> type) {
                Object result = delegate.getProperty(name);
                if (result == null && (result = configuration.getProperty(name)) == null) {
                    result = defaultValue;
                }
                return result == null ? null : (T)PropertiesHelper.convertValue(result, type);
            }
        };
    }
}

