/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.client;

import com.iterable.shade.org.glassfish.jersey.SslConfigurator;
import com.iterable.shade.org.glassfish.jersey.client.internal.LocalizationMessages;
import com.iterable.shade.org.glassfish.jersey.client.spi.DefaultSslContextProvider;
import com.iterable.shade.org.glassfish.jersey.internal.ServiceFinder;
import com.iterable.shade.org.glassfish.jersey.internal.util.collection.Values;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class SslContextClientBuilder
implements Supplier<SSLContext> {
    private SslConfigurator sslConfigurator = null;
    private SSLContext sslContext = null;
    private DefaultSslContextProvider defaultSslContextProvider = null;
    private final Supplier<SSLContext> suppliedValue = Values.lazy(() -> this.supply());
    private static final DefaultSslContextProvider DEFAULT_SSL_CONTEXT_PROVIDER = new DefaultSslContextProvider(){

        @Override
        public SSLContext getDefaultSslContext() {
            return SslConfigurator.getDefaultContext();
        }
    };

    public SslContextClientBuilder sslContext(SSLContext sslContext) {
        if (sslContext == null) {
            throw new NullPointerException(LocalizationMessages.NULL_SSL_CONTEXT());
        }
        this.sslContext = sslContext;
        this.sslConfigurator = null;
        return this;
    }

    public SslContextClientBuilder keyStore(KeyStore keyStore, char[] password) {
        if (keyStore == null) {
            throw new NullPointerException(LocalizationMessages.NULL_KEYSTORE());
        }
        if (password == null) {
            throw new NullPointerException(LocalizationMessages.NULL_KEYSTORE_PASWORD());
        }
        if (this.sslConfigurator == null) {
            this.sslConfigurator = SslConfigurator.newInstance();
        }
        this.sslConfigurator.keyStore(keyStore);
        this.sslConfigurator.keyPassword(password);
        this.sslContext = null;
        return this;
    }

    public SslContextClientBuilder trustStore(KeyStore trustStore) {
        if (trustStore == null) {
            throw new NullPointerException(LocalizationMessages.NULL_TRUSTSTORE());
        }
        if (this.sslConfigurator == null) {
            this.sslConfigurator = SslConfigurator.newInstance();
        }
        this.sslConfigurator.trustStore(trustStore);
        this.sslContext = null;
        return this;
    }

    public SslContextClientBuilder keyStore(KeyStore keyStore, String password) {
        return this.keyStore(keyStore, password.toCharArray());
    }

    public boolean isDefaultSslContext() {
        return this.sslContext == null && this.sslConfigurator == null;
    }

    @Override
    public SSLContext get() {
        return this.suppliedValue.get();
    }

    public SSLContext build() {
        return this.suppliedValue.get();
    }

    protected SslContextClientBuilder defaultSslContextProvider(DefaultSslContextProvider defaultSslContextProvider) {
        this.defaultSslContextProvider = defaultSslContextProvider;
        return this;
    }

    private SSLContext supply() {
        SSLContext returnValue;
        SSLContext providedValue;
        if (this.sslContext != null) {
            providedValue = this.sslContext;
        } else if (this.sslConfigurator != null) {
            SslConfigurator sslConfiguratorCopy = this.sslConfigurator.copy();
            providedValue = sslConfiguratorCopy.createSSLContext();
        } else {
            providedValue = null;
        }
        if (providedValue == null) {
            if (this.defaultSslContextProvider != null) {
                returnValue = this.defaultSslContextProvider.getDefaultSslContext();
            } else {
                Iterator<DefaultSslContextProvider> iterator = ServiceFinder.find(DefaultSslContextProvider.class).iterator();
                DefaultSslContextProvider lookedUpSslContextProvider = iterator.hasNext() ? iterator.next() : DEFAULT_SSL_CONTEXT_PROVIDER;
                returnValue = lookedUpSslContextProvider.getDefaultSslContext();
            }
        } else {
            returnValue = providedValue;
        }
        return returnValue;
    }
}

