/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.glassfish.jersey.client;

import com.iterable.shade.javax.inject.Inject;
import com.iterable.shade.javax.inject.Provider;
import com.iterable.shade.javax.ws.rs.ConstrainedTo;
import com.iterable.shade.javax.ws.rs.RuntimeType;
import com.iterable.shade.javax.ws.rs.WebApplicationException;
import com.iterable.shade.javax.ws.rs.core.Context;
import com.iterable.shade.javax.ws.rs.core.MediaType;
import com.iterable.shade.javax.ws.rs.core.MultivaluedMap;
import com.iterable.shade.javax.ws.rs.ext.MessageBodyReader;
import com.iterable.shade.org.glassfish.jersey.client.ChunkedInput;
import com.iterable.shade.org.glassfish.jersey.internal.PropertiesDelegate;
import com.iterable.shade.org.glassfish.jersey.internal.util.ReflectionHelper;
import com.iterable.shade.org.glassfish.jersey.message.MessageBodyWorkers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@ConstrainedTo(value=RuntimeType.CLIENT)
class ChunkedInputReader
implements MessageBodyReader<ChunkedInput> {
    private final Provider<MessageBodyWorkers> messageBodyWorkers;
    private final Provider<PropertiesDelegate> propertiesDelegateProvider;

    @Inject
    public ChunkedInputReader(@Context Provider<MessageBodyWorkers> messageBodyWorkers, @Context Provider<PropertiesDelegate> propertiesDelegateProvider) {
        this.messageBodyWorkers = messageBodyWorkers;
        this.propertiesDelegateProvider = propertiesDelegateProvider;
    }

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(ChunkedInput.class);
    }

    @Override
    public ChunkedInput readFrom(Class<ChunkedInput> chunkedInputClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream) throws IOException, WebApplicationException {
        Type chunkType = ReflectionHelper.getTypeArgument(type, 0);
        return new ChunkedInput(chunkType, inputStream, annotations, mediaType, headers, this.messageBodyWorkers.get(), this.propertiesDelegateProvider.get());
    }
}

