/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.ws;

import com.iterable.shade.io.netty.util.internal.ThreadLocalRandom;
import com.iterable.shade.org.asynchttpclient.util.MessageDigestUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class WebSocketUtils {
    private static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public static String getWebSocketKey() {
        byte[] nonce = new byte[16];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < nonce.length; ++i) {
            nonce[i] = (byte)random.nextInt(256);
        }
        return Base64.getEncoder().encodeToString(nonce);
    }

    public static String getAcceptKey(String key) {
        return Base64.getEncoder().encodeToString(MessageDigestUtils.pooledSha1MessageDigest().digest((key + MAGIC_GUID).getBytes(StandardCharsets.US_ASCII)));
    }
}

