/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.oauth;

import com.iterable.shade.io.netty.handler.codec.http.HttpHeaderNames;
import com.iterable.shade.org.asynchttpclient.Request;
import com.iterable.shade.org.asynchttpclient.RequestBuilderBase;
import com.iterable.shade.org.asynchttpclient.SignatureCalculator;
import com.iterable.shade.org.asynchttpclient.oauth.ConsumerKey;
import com.iterable.shade.org.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import com.iterable.shade.org.asynchttpclient.oauth.RequestToken;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = ThreadLocal.withInitial(() -> {
        try {
            return new OAuthSignatureCalculatorInstance();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    });
    private final ConsumerKey consumerAuth;
    private final RequestToken userAuth;

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
    }

    @Override
    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            String authorization = INSTANCES.get().computeAuthorizationHeader(this.consumerAuth, this.userAuth, request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams());
            requestBuilder.setHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, authorization);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Failed to compute a valid key from consumer and user secrets", e);
        }
    }
}

