/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.netty.request.body;

import com.iterable.shade.com.typesafe.netty.HandlerSubscriber;
import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.channel.ChannelHandler;
import com.iterable.shade.io.netty.handler.codec.http.DefaultHttpContent;
import com.iterable.shade.io.netty.handler.codec.http.HttpContent;
import com.iterable.shade.io.netty.handler.codec.http.LastHttpContent;
import com.iterable.shade.io.netty.util.concurrent.Future;
import com.iterable.shade.io.netty.util.concurrent.GenericFutureListener;
import com.iterable.shade.org.asynchttpclient.netty.NettyResponseFuture;
import com.iterable.shade.org.asynchttpclient.netty.request.body.NettyBody;
import com.iterable.shade.org.asynchttpclient.util.Assertions;
import com.iterable.shade.org.reactivestreams.Publisher;
import com.iterable.shade.org.reactivestreams.Subscriber;
import com.iterable.shade.org.reactivestreams.Subscription;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyReactiveStreamsBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyReactiveStreamsBody.class);
    private static final String NAME_IN_CHANNEL_PIPELINE = "request-body-streamer";
    private final Publisher<ByteBuf> publisher;
    private final long contentLength;

    public NettyReactiveStreamsBody(Publisher<ByteBuf> publisher, long contentLength) {
        this.publisher = publisher;
        this.contentLength = contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        if (future.isStreamConsumed()) {
            LOGGER.warn("Stream has already been consumed and cannot be reset");
        } else {
            future.setStreamConsumed(true);
            NettySubscriber subscriber = new NettySubscriber(channel, future);
            channel.pipeline().addLast(NAME_IN_CHANNEL_PIPELINE, (ChannelHandler)subscriber);
            this.publisher.subscribe(new SubscriberAdapter(subscriber));
            subscriber.delayedStart();
        }
    }

    private static class NettySubscriber
    extends HandlerSubscriber<HttpContent> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NettySubscriber.class);
        private static final Subscription DO_NOT_DELAY = new Subscription(){

            @Override
            public void cancel() {
            }

            @Override
            public void request(long l) {
            }
        };
        private final Channel channel;
        private final NettyResponseFuture<?> future;
        private AtomicReference<Subscription> deferredSubscription = new AtomicReference();

        NettySubscriber(Channel channel, NettyResponseFuture<?> future) {
            super(channel.eventLoop());
            this.channel = channel;
            this.future = future;
        }

        @Override
        protected void complete() {
            this.channel.eventLoop().execute(() -> this.channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.removeFromPipeline())));
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (!this.deferredSubscription.compareAndSet(null, subscription)) {
                super.onSubscribe(subscription);
            }
        }

        void delayedStart() {
            Subscription subscription = this.deferredSubscription.getAndSet(DO_NOT_DELAY);
            if (subscription != null) {
                super.onSubscribe(subscription);
            }
        }

        @Override
        protected void error(Throwable error) {
            Assertions.assertNotNull(error, "error");
            this.removeFromPipeline();
            this.future.abort(error);
        }

        private void removeFromPipeline() {
            try {
                this.channel.pipeline().remove(this);
                LOGGER.debug(String.format("Removed handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE));
            }
            catch (NoSuchElementException e) {
                LOGGER.debug(String.format("Failed to remove handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE), (Throwable)e);
            }
        }
    }

    private static class SubscriberAdapter
    implements Subscriber<ByteBuf> {
        private final Subscriber<HttpContent> subscriber;

        SubscriberAdapter(Subscriber<HttpContent> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.subscriber.onSubscribe(s2);
        }

        @Override
        public void onNext(ByteBuf buffer) {
            DefaultHttpContent content = new DefaultHttpContent(buffer);
            this.subscriber.onNext(content);
        }

        @Override
        public void onError(Throwable t2) {
            this.subscriber.onError(t2);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

