/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.netty.request.body;

import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.channel.ChannelProgressiveFuture;
import com.iterable.shade.io.netty.handler.codec.http.LastHttpContent;
import com.iterable.shade.io.netty.handler.stream.ChunkedWriteHandler;
import com.iterable.shade.org.asynchttpclient.AsyncHttpClientConfig;
import com.iterable.shade.org.asynchttpclient.netty.NettyResponseFuture;
import com.iterable.shade.org.asynchttpclient.netty.channel.ChannelManager;
import com.iterable.shade.org.asynchttpclient.netty.request.WriteProgressListener;
import com.iterable.shade.org.asynchttpclient.netty.request.body.BodyChunkedInput;
import com.iterable.shade.org.asynchttpclient.netty.request.body.BodyFileRegion;
import com.iterable.shade.org.asynchttpclient.netty.request.body.NettyBody;
import com.iterable.shade.org.asynchttpclient.request.body.Body;
import com.iterable.shade.org.asynchttpclient.request.body.RandomAccessBody;
import com.iterable.shade.org.asynchttpclient.request.body.generator.BodyGenerator;
import com.iterable.shade.org.asynchttpclient.request.body.generator.FeedListener;
import com.iterable.shade.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import com.iterable.shade.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import com.iterable.shade.org.asynchttpclient.util.MiscUtils;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy() && this.getContentLength() > 0L) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator && !(bg instanceof ReactiveStreamsBodyGenerator)) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t2) {
                    }
                });
            }
        }
        channel.write(msg, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

