/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.netty.handler.intercept;

import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.handler.codec.http.HttpHeaders;
import com.iterable.shade.org.asynchttpclient.AsyncHandler;
import com.iterable.shade.org.asynchttpclient.AsyncHttpClientConfig;
import com.iterable.shade.org.asynchttpclient.HttpResponseStatus;
import com.iterable.shade.org.asynchttpclient.filter.FilterContext;
import com.iterable.shade.org.asynchttpclient.filter.FilterException;
import com.iterable.shade.org.asynchttpclient.filter.ResponseFilter;
import com.iterable.shade.org.asynchttpclient.netty.NettyResponseFuture;
import com.iterable.shade.org.asynchttpclient.netty.request.NettyRequestSender;
import com.iterable.shade.org.asynchttpclient.util.Assertions;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(handler).request(future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull("fc", "filterContext");
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

