/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.handler;

import com.iterable.shade.io.netty.handler.codec.http.HttpHeaders;
import com.iterable.shade.org.asynchttpclient.AsyncCompletionHandlerBase;
import com.iterable.shade.org.asynchttpclient.AsyncHandler;
import com.iterable.shade.org.asynchttpclient.HttpResponseBodyPart;
import com.iterable.shade.org.asynchttpclient.Response;
import com.iterable.shade.org.asynchttpclient.handler.TransferListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferCompletionHandler
extends AsyncCompletionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final boolean accumulateResponseBytes;
    private HttpHeaders headers;

    public TransferCompletionHandler() {
        this(false);
    }

    public TransferCompletionHandler(boolean accumulateResponseBytes) {
        this.accumulateResponseBytes = accumulateResponseBytes;
    }

    public TransferCompletionHandler addTransferListener(TransferListener t2) {
        this.listeners.offer(t2);
        return this;
    }

    public TransferCompletionHandler removeTransferListener(TransferListener t2) {
        this.listeners.remove(t2);
        return this;
    }

    public void headers(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        this.fireOnHeaderReceived(headers);
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onTrailingHeadersReceived(HttpHeaders headers) throws Exception {
        this.fireOnHeaderReceived(headers);
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        AsyncHandler.State s2 = AsyncHandler.State.CONTINUE;
        if (this.accumulateResponseBytes) {
            s2 = super.onBodyPartReceived(content);
        }
        this.fireOnBytesReceived(content.getBodyPartBytes());
        return s2;
    }

    @Override
    public Response onCompleted(Response response) throws Exception {
        this.fireOnEnd();
        return response;
    }

    @Override
    public AsyncHandler.State onHeadersWritten() {
        if (this.headers != null) {
            this.fireOnHeadersSent(this.headers);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onContentWriteProgress(long amount, long current, long total) {
        this.fireOnBytesSent(amount, current, total);
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t2) {
        this.fireOnThrowable(t2);
    }

    private void fireOnHeadersSent(HttpHeaders headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestHeadersSent(headers);
            }
            catch (Throwable t2) {
                l.onThrowable(t2);
            }
        }
    }

    private void fireOnHeaderReceived(HttpHeaders headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onResponseHeadersReceived(headers);
            }
            catch (Throwable t2) {
                l.onThrowable(t2);
            }
        }
    }

    private void fireOnEnd() {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestResponseCompleted();
            }
            catch (Throwable t2) {
                l.onThrowable(t2);
            }
        }
    }

    private void fireOnBytesReceived(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesReceived(b);
            }
            catch (Throwable t2) {
                l.onThrowable(t2);
            }
        }
    }

    private void fireOnBytesSent(long amount, long current, long total) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesSent(amount, current, total);
            }
            catch (Throwable t2) {
                l.onThrowable(t2);
            }
        }
    }

    private void fireOnThrowable(Throwable t2) {
        for (TransferListener l : this.listeners) {
            try {
                l.onThrowable(t2);
            }
            catch (Throwable t22) {
                logger.warn("onThrowable", t22);
            }
        }
    }
}

