/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient.filter;

import com.iterable.shade.org.asynchttpclient.filter.FilterContext;
import com.iterable.shade.org.asynchttpclient.filter.FilterException;
import com.iterable.shade.org.asynchttpclient.filter.ReleasePermitOnComplete;
import com.iterable.shade.org.asynchttpclient.filter.RequestFilter;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleRequestFilter
implements RequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ThrottleRequestFilter.class);
    private final Semaphore available;
    private final int maxWait;

    public ThrottleRequestFilter(int maxConnections) {
        this(maxConnections, Integer.MAX_VALUE);
    }

    public ThrottleRequestFilter(int maxConnections, int maxWait) {
        this(maxConnections, maxWait, false);
    }

    public ThrottleRequestFilter(int maxConnections, int maxWait, boolean fair) {
        this.maxWait = maxWait;
        this.available = new Semaphore(maxConnections, fair);
    }

    @Override
    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Current Throttling Status {}", (Object)this.available.availablePermits());
            }
            if (!this.available.tryAcquire(this.maxWait, TimeUnit.MILLISECONDS)) {
                throw new FilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
            }
        }
        catch (InterruptedException e) {
            throw new FilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new FilterContext.FilterContextBuilder<T>(ctx).asyncHandler(ReleasePermitOnComplete.wrap(ctx.getAsyncHandler(), this.available)).build();
    }
}

