/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient;

import com.iterable.shade.io.netty.handler.codec.http.HttpHeaders;
import com.iterable.shade.io.netty.handler.codec.http.cookie.Cookie;
import com.iterable.shade.org.asynchttpclient.HttpResponseBodyPart;
import com.iterable.shade.org.asynchttpclient.HttpResponseStatus;
import com.iterable.shade.org.asynchttpclient.netty.NettyResponse;
import com.iterable.shade.org.asynchttpclient.uri.Uri;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public interface Response {
    public int getStatusCode();

    public String getStatusText();

    public byte[] getResponseBodyAsBytes();

    public ByteBuffer getResponseBodyAsByteBuffer();

    public InputStream getResponseBodyAsStream();

    public String getResponseBody(Charset var1);

    public String getResponseBody();

    public Uri getUri();

    public String getContentType();

    public String getHeader(CharSequence var1);

    public List<String> getHeaders(CharSequence var1);

    public HttpHeaders getHeaders();

    public boolean isRedirected();

    public String toString();

    public List<Cookie> getCookies();

    public boolean hasResponseStatus();

    public boolean hasResponseHeaders();

    public boolean hasResponseBody();

    public SocketAddress getRemoteAddress();

    public SocketAddress getLocalAddress();

    public static class ResponseBuilder {
        private final List<HttpResponseBodyPart> bodyParts = new ArrayList<HttpResponseBodyPart>(1);
        private HttpResponseStatus status;
        private HttpHeaders headers;

        public void accumulate(HttpResponseStatus status) {
            this.status = status;
        }

        public void accumulate(HttpHeaders headers) {
            this.headers = this.headers == null ? headers : this.headers.add(headers);
        }

        public void accumulate(HttpResponseBodyPart bodyPart) {
            if (bodyPart.length() > 0) {
                this.bodyParts.add(bodyPart);
            }
        }

        public Response build() {
            return this.status == null ? null : new NettyResponse(this.status, this.headers, this.bodyParts);
        }

        public void reset() {
            this.bodyParts.clear();
            this.status = null;
            this.headers = null;
        }
    }
}

