/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.asynchttpclient;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.ByteBufAllocator;
import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.channel.ChannelOption;
import com.iterable.shade.io.netty.channel.EventLoopGroup;
import com.iterable.shade.io.netty.handler.ssl.SslContext;
import com.iterable.shade.io.netty.util.Timer;
import com.iterable.shade.org.asynchttpclient.HttpResponseBodyPart;
import com.iterable.shade.org.asynchttpclient.Realm;
import com.iterable.shade.org.asynchttpclient.SslEngineFactory;
import com.iterable.shade.org.asynchttpclient.channel.ChannelPool;
import com.iterable.shade.org.asynchttpclient.channel.KeepAliveStrategy;
import com.iterable.shade.org.asynchttpclient.cookie.CookieStore;
import com.iterable.shade.org.asynchttpclient.filter.IOExceptionFilter;
import com.iterable.shade.org.asynchttpclient.filter.RequestFilter;
import com.iterable.shade.org.asynchttpclient.filter.ResponseFilter;
import com.iterable.shade.org.asynchttpclient.netty.EagerResponseBodyPart;
import com.iterable.shade.org.asynchttpclient.netty.LazyResponseBodyPart;
import com.iterable.shade.org.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import com.iterable.shade.org.asynchttpclient.proxy.ProxyServerSelector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

public interface AsyncHttpClientConfig {
    public String getAhcVersion();

    public String getThreadPoolName();

    public int getMaxConnections();

    public int getMaxConnectionsPerHost();

    public int getAcquireFreeChannelTimeout();

    public int getConnectTimeout();

    public int getReadTimeout();

    public int getPooledConnectionIdleTimeout();

    public int getConnectionPoolCleanerPeriod();

    public int getRequestTimeout();

    public boolean isFollowRedirect();

    public int getMaxRedirects();

    public boolean isKeepAlive();

    public String getUserAgent();

    public boolean isCompressionEnforced();

    public ThreadFactory getThreadFactory();

    public ProxyServerSelector getProxyServerSelector();

    public SslContext getSslContext();

    public Realm getRealm();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    public List<IOExceptionFilter> getIoExceptionFilters();

    public CookieStore getCookieStore();

    public int expiredCookieEvictionDelay();

    public int getMaxRequestRetry();

    public boolean isDisableUrlEncodingForBoundRequests();

    public boolean isUseLaxCookieEncoder();

    public boolean isStrict302Handling();

    public int getConnectionTtl();

    public boolean isUseOpenSsl();

    public boolean isUseInsecureTrustManager();

    public boolean isDisableHttpsEndpointIdentificationAlgorithm();

    public String[] getEnabledProtocols();

    public String[] getEnabledCipherSuites();

    public boolean isFilterInsecureCipherSuites();

    public int getSslSessionCacheSize();

    public int getSslSessionTimeout();

    public int getHttpClientCodecMaxInitialLineLength();

    public int getHttpClientCodecMaxHeaderSize();

    public int getHttpClientCodecMaxChunkSize();

    public int getHttpClientCodecInitialBufferSize();

    public boolean isDisableZeroCopy();

    public int getHandshakeTimeout();

    public SslEngineFactory getSslEngineFactory();

    public int getChunkedFileChunkSize();

    public int getWebSocketMaxBufferSize();

    public int getWebSocketMaxFrameSize();

    public boolean isKeepEncodingHeader();

    public int getShutdownQuietPeriod();

    public int getShutdownTimeout();

    public Map<ChannelOption<Object>, Object> getChannelOptions();

    public EventLoopGroup getEventLoopGroup();

    public boolean isUseNativeTransport();

    public Consumer<Channel> getHttpAdditionalChannelInitializer();

    public Consumer<Channel> getWsAdditionalChannelInitializer();

    public ResponseBodyPartFactory getResponseBodyPartFactory();

    public ChannelPool getChannelPool();

    public ConnectionSemaphoreFactory getConnectionSemaphoreFactory();

    public Timer getNettyTimer();

    public long getHashedWheelTimerTickDuration();

    public int getHashedWheelTimerSize();

    public KeepAliveStrategy getKeepAliveStrategy();

    public boolean isValidateResponseHeaders();

    public boolean isAggregateWebSocketFrameFragments();

    public boolean isEnableWebSocketCompression();

    public boolean isTcpNoDelay();

    public boolean isSoReuseAddress();

    public boolean isSoKeepAlive();

    public int getSoLinger();

    public int getSoSndBuf();

    public int getSoRcvBuf();

    public ByteBufAllocator getAllocator();

    public int getIoThreadsCount();

    public static enum ResponseBodyPartFactory {
        EAGER{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new EagerResponseBodyPart(buf, last);
            }
        }
        ,
        LAZY{

            @Override
            public HttpResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new LazyResponseBodyPart(buf, last);
            }
        };


        public abstract HttpResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }
}

