/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.pulsar.policies.data.loadbalancer;

import com.iterable.shade.org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import com.iterable.shade.org.apache.pulsar.policies.data.loadbalancer.TimeAverageMessageData;

public class BundleData {
    private TimeAverageMessageData shortTermData;
    private TimeAverageMessageData longTermData;
    private int topics;

    public BundleData() {
    }

    public BundleData(int numShortSamples, int numLongSamples) {
        this.shortTermData = new TimeAverageMessageData(numShortSamples);
        this.longTermData = new TimeAverageMessageData(numLongSamples);
    }

    public BundleData(int numShortSamples, int numLongSamples, NamespaceBundleStats defaultStats) {
        this.shortTermData = new TimeAverageMessageData(numShortSamples, defaultStats);
        this.longTermData = new TimeAverageMessageData(numLongSamples, defaultStats);
    }

    public void update(NamespaceBundleStats newSample) {
        this.shortTermData.update(newSample);
        this.longTermData.update(newSample);
        this.topics = (int)newSample.topics;
    }

    public TimeAverageMessageData getShortTermData() {
        return this.shortTermData;
    }

    public void setShortTermData(TimeAverageMessageData shortTermData) {
        this.shortTermData = shortTermData;
    }

    public TimeAverageMessageData getLongTermData() {
        return this.longTermData;
    }

    public void setLongTermData(TimeAverageMessageData longTermData) {
        this.longTermData = longTermData;
    }

    public int getTopics() {
        return this.topics;
    }

    public void setTopics(int topics) {
        this.topics = topics;
    }
}

