/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.pulsar.policies.data.loadbalancer;

import java.net.URI;

public class AdvertisedListener {
    private URI brokerServiceUrl;
    private URI brokerServiceUrlTls;
    private URI brokerHttpUrl;
    private URI brokerHttpsUrl;

    public boolean hasUriForProtocol(String protocol) {
        if ("pulsar".equals(protocol)) {
            return this.brokerServiceUrl != null;
        }
        if ("pulsar+ssl".equals(protocol)) {
            return this.brokerServiceUrlTls != null;
        }
        if ("http".equals(protocol)) {
            return this.brokerHttpUrl != null;
        }
        if ("https".equals(protocol)) {
            return this.brokerHttpsUrl != null;
        }
        return false;
    }

    public static AdvertisedListenerBuilder builder() {
        return new AdvertisedListenerBuilder();
    }

    public AdvertisedListener() {
    }

    public AdvertisedListener(URI brokerServiceUrl, URI brokerServiceUrlTls, URI brokerHttpUrl, URI brokerHttpsUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
        this.brokerServiceUrlTls = brokerServiceUrlTls;
        this.brokerHttpUrl = brokerHttpUrl;
        this.brokerHttpsUrl = brokerHttpsUrl;
    }

    public URI getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public URI getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public URI getBrokerHttpUrl() {
        return this.brokerHttpUrl;
    }

    public URI getBrokerHttpsUrl() {
        return this.brokerHttpsUrl;
    }

    public void setBrokerServiceUrl(URI brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    public void setBrokerServiceUrlTls(URI brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    public void setBrokerHttpUrl(URI brokerHttpUrl) {
        this.brokerHttpUrl = brokerHttpUrl;
    }

    public void setBrokerHttpsUrl(URI brokerHttpsUrl) {
        this.brokerHttpsUrl = brokerHttpsUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvertisedListener)) {
            return false;
        }
        AdvertisedListener other = (AdvertisedListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$brokerServiceUrl = this.getBrokerServiceUrl();
        URI other$brokerServiceUrl = other.getBrokerServiceUrl();
        if (this$brokerServiceUrl == null ? other$brokerServiceUrl != null : !((Object)this$brokerServiceUrl).equals(other$brokerServiceUrl)) {
            return false;
        }
        URI this$brokerServiceUrlTls = this.getBrokerServiceUrlTls();
        URI other$brokerServiceUrlTls = other.getBrokerServiceUrlTls();
        if (this$brokerServiceUrlTls == null ? other$brokerServiceUrlTls != null : !((Object)this$brokerServiceUrlTls).equals(other$brokerServiceUrlTls)) {
            return false;
        }
        URI this$brokerHttpUrl = this.getBrokerHttpUrl();
        URI other$brokerHttpUrl = other.getBrokerHttpUrl();
        if (this$brokerHttpUrl == null ? other$brokerHttpUrl != null : !((Object)this$brokerHttpUrl).equals(other$brokerHttpUrl)) {
            return false;
        }
        URI this$brokerHttpsUrl = this.getBrokerHttpsUrl();
        URI other$brokerHttpsUrl = other.getBrokerHttpsUrl();
        return !(this$brokerHttpsUrl == null ? other$brokerHttpsUrl != null : !((Object)this$brokerHttpsUrl).equals(other$brokerHttpsUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvertisedListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $brokerServiceUrl = this.getBrokerServiceUrl();
        result = result * 59 + ($brokerServiceUrl == null ? 43 : ((Object)$brokerServiceUrl).hashCode());
        URI $brokerServiceUrlTls = this.getBrokerServiceUrlTls();
        result = result * 59 + ($brokerServiceUrlTls == null ? 43 : ((Object)$brokerServiceUrlTls).hashCode());
        URI $brokerHttpUrl = this.getBrokerHttpUrl();
        result = result * 59 + ($brokerHttpUrl == null ? 43 : ((Object)$brokerHttpUrl).hashCode());
        URI $brokerHttpsUrl = this.getBrokerHttpsUrl();
        result = result * 59 + ($brokerHttpsUrl == null ? 43 : ((Object)$brokerHttpsUrl).hashCode());
        return result;
    }

    public String toString() {
        return "AdvertisedListener(brokerServiceUrl=" + this.getBrokerServiceUrl() + ", brokerServiceUrlTls=" + this.getBrokerServiceUrlTls() + ", brokerHttpUrl=" + this.getBrokerHttpUrl() + ", brokerHttpsUrl=" + this.getBrokerHttpsUrl() + ")";
    }

    public static class AdvertisedListenerBuilder {
        private URI brokerServiceUrl;
        private URI brokerServiceUrlTls;
        private URI brokerHttpUrl;
        private URI brokerHttpsUrl;

        AdvertisedListenerBuilder() {
        }

        public AdvertisedListenerBuilder brokerServiceUrl(URI brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
            return this;
        }

        public AdvertisedListenerBuilder brokerServiceUrlTls(URI brokerServiceUrlTls) {
            this.brokerServiceUrlTls = brokerServiceUrlTls;
            return this;
        }

        public AdvertisedListenerBuilder brokerHttpUrl(URI brokerHttpUrl) {
            this.brokerHttpUrl = brokerHttpUrl;
            return this;
        }

        public AdvertisedListenerBuilder brokerHttpsUrl(URI brokerHttpsUrl) {
            this.brokerHttpsUrl = brokerHttpsUrl;
            return this;
        }

        public AdvertisedListener build() {
            return new AdvertisedListener(this.brokerServiceUrl, this.brokerServiceUrlTls, this.brokerHttpUrl, this.brokerHttpsUrl);
        }

        public String toString() {
            return "AdvertisedListener.AdvertisedListenerBuilder(brokerServiceUrl=" + this.brokerServiceUrl + ", brokerServiceUrlTls=" + this.brokerServiceUrlTls + ", brokerHttpUrl=" + this.brokerHttpUrl + ", brokerHttpsUrl=" + this.brokerHttpsUrl + ")";
        }
    }
}

