/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.commons.configuration.tree.xpath;

import com.iterable.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import com.iterable.shade.org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorBase;
import com.iterable.shade.org.apache.commons.jxpath.ri.QName;
import com.iterable.shade.org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import com.iterable.shade.org.apache.commons.jxpath.ri.compiler.NodeTest;
import com.iterable.shade.org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import com.iterable.shade.org.apache.commons.jxpath.ri.model.NodePointer;
import com.iterable.shade.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationNodeIteratorChildren
extends ConfigurationNodeIteratorBase {
    public ConfigurationNodeIteratorChildren(NodePointer parent, NodeTest nodeTest, boolean reverse, NodePointer startsWith) {
        super(parent, reverse);
        ConfigurationNode root = (ConfigurationNode)parent.getNode();
        List<ConfigurationNode> childNodes = this.createSubNodeList(root, nodeTest);
        this.initSubNodeList(childNodes);
        if (startsWith != null) {
            this.setStartOffset(this.findStartIndex(root, (ConfigurationNode)startsWith.getNode()));
        }
    }

    protected List<ConfigurationNode> createSubNodeList(ConfigurationNode node, NodeTest test) {
        NodeTypeTest typeTest;
        List<ConfigurationNode> children = node.getChildren();
        if (test == null) {
            return children;
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nameTest = (NodeNameTest)test;
            QName name = nameTest.getNodeName();
            if (name.getPrefix() == null) {
                if (nameTest.isWildcard()) {
                    return children;
                }
                ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>();
                for (ConfigurationNode child : children) {
                    if (!StringUtils.equals(name.getName(), child.getName())) continue;
                    result.add(child);
                }
                return result;
            }
        } else if (test instanceof NodeTypeTest && ((typeTest = (NodeTypeTest)test).getNodeType() == 1 || typeTest.getNodeType() == 2)) {
            return children;
        }
        return Collections.emptyList();
    }

    protected int findStartIndex(ConfigurationNode node, ConfigurationNode startNode) {
        for (int index = 0; index < node.getChildrenCount(); ++index) {
            if (node.getChild(index) != startNode) continue;
            return index;
        }
        return -1;
    }
}

