/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.commons.configuration.reloading;

import com.iterable.shade.org.apache.commons.configuration.ConfigurationUtils;
import com.iterable.shade.org.apache.commons.configuration.FileConfiguration;
import com.iterable.shade.org.apache.commons.configuration.reloading.ReloadingStrategy;
import com.iterable.shade.org.apache.commons.logging.Log;
import com.iterable.shade.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class FileChangedReloadingStrategy
implements ReloadingStrategy {
    private static final String JAR_PROTOCOL = "jar";
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;
    private boolean reloading;
    private Log logger = LogFactory.getLog(FileChangedReloadingStrategy.class);

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        long now;
        if (!this.reloading && (now = System.currentTimeMillis()) > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("File change detected: " + this.getName());
                }
                this.reloading = true;
            }
        }
        return this.reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        File file = this.getFile();
        if (file != null) {
            this.lastModified = file.lastModified();
        }
        this.reloading = false;
    }

    protected boolean hasChanged() {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            if (this.logger.isWarnEnabled() && this.lastModified != 0L) {
                this.logger.warn("File was deleted: " + this.getName(file));
                this.lastModified = 0L;
            }
            return false;
        }
        return file.lastModified() > this.lastModified;
    }

    protected File getFile() {
        return this.configuration.getURL() != null ? this.fileFromURL(this.configuration.getURL()) : this.configuration.getFile();
    }

    private File fileFromURL(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String path = url.getPath();
            try {
                return ConfigurationUtils.fileFromURL(new URL(path.substring(0, path.indexOf(33))));
            }
            catch (MalformedURLException mex) {
                return null;
            }
        }
        return ConfigurationUtils.fileFromURL(url);
    }

    private String getName() {
        return this.getName(this.getFile());
    }

    private String getName(File file) {
        String name = this.configuration.getURL().toString();
        if (name == null) {
            name = file != null ? file.getAbsolutePath() : "base: " + this.configuration.getBasePath() + "file: " + this.configuration.getFileName();
        }
        return name;
    }
}

