/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.commons.configuration.interpol;

import com.iterable.shade.org.apache.commons.configuration.interpol.ConstantLookup;
import com.iterable.shade.org.apache.commons.configuration.interpol.EnvironmentLookup;
import com.iterable.shade.org.apache.commons.lang.text.StrLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationInterpolator
extends StrLookup {
    public static final String PREFIX_SYSPROPERTIES = "sys";
    public static final String PREFIX_CONSTANTS = "const";
    public static final String PREFIX_ENVIRONMENT = "env";
    private static final char PREFIX_SEPARATOR = ':';
    private static Map<String, StrLookup> globalLookups = new HashMap<String, StrLookup>();
    private Map<String, StrLookup> localLookups;
    private StrLookup defaultLookup;
    private ConfigurationInterpolator parentInterpolator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationInterpolator() {
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            this.localLookups = new HashMap<String, StrLookup>(globalLookups);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalLookup(String prefix, StrLookup lookup) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            globalLookups.put(prefix, lookup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deregisterGlobalLookup(String prefix) {
        Map<String, StrLookup> map = globalLookups;
        synchronized (map) {
            return globalLookups.remove(prefix) != null;
        }
    }

    public void registerLookup(String prefix, StrLookup lookup) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix for lookup object must not be null!");
        }
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup object must not be null!");
        }
        this.localLookups.put(prefix, lookup);
    }

    public boolean deregisterLookup(String prefix) {
        return this.localLookups.remove(prefix) != null;
    }

    public Set<String> prefixSet() {
        return this.localLookups.keySet();
    }

    public StrLookup getDefaultLookup() {
        return this.defaultLookup;
    }

    public void setDefaultLookup(StrLookup defaultLookup) {
        this.defaultLookup = defaultLookup;
    }

    @Override
    public String lookup(String var) {
        String value;
        if (var == null) {
            return null;
        }
        int prefixPos = var.indexOf(58);
        if (prefixPos >= 0) {
            String prefix = var.substring(0, prefixPos);
            String name = var.substring(prefixPos + 1);
            String value2 = this.fetchLookupForPrefix(prefix).lookup(name);
            if (value2 == null && this.getParentInterpolator() != null) {
                value2 = this.getParentInterpolator().lookup(name);
            }
            if (value2 != null) {
                return value2;
            }
        }
        if ((value = this.fetchNoPrefixLookup().lookup(var)) == null && this.getParentInterpolator() != null) {
            value = this.getParentInterpolator().lookup(var);
        }
        return value;
    }

    protected StrLookup fetchNoPrefixLookup() {
        return this.getDefaultLookup() != null ? this.getDefaultLookup() : StrLookup.noneLookup();
    }

    protected StrLookup fetchLookupForPrefix(String prefix) {
        StrLookup lookup = this.localLookups.get(prefix);
        if (lookup == null) {
            lookup = StrLookup.noneLookup();
        }
        return lookup;
    }

    public void registerLocalLookups(ConfigurationInterpolator interpolator) {
        interpolator.localLookups.putAll(this.localLookups);
    }

    public void setParentInterpolator(ConfigurationInterpolator parentInterpolator) {
        this.parentInterpolator = parentInterpolator;
    }

    public ConfigurationInterpolator getParentInterpolator() {
        return this.parentInterpolator;
    }

    static {
        globalLookups.put(PREFIX_SYSPROPERTIES, StrLookup.systemPropertiesLookup());
        globalLookups.put(PREFIX_CONSTANTS, new ConstantLookup());
        globalLookups.put(PREFIX_ENVIRONMENT, new EnvironmentLookup());
    }
}

