/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.commons.configuration;

import com.iterable.shade.org.apache.commons.configuration.AbstractConfiguration;
import com.iterable.shade.org.apache.commons.configuration.CombinedConfiguration;
import com.iterable.shade.org.apache.commons.configuration.Configuration;
import com.iterable.shade.org.apache.commons.configuration.ConfigurationBuilder;
import com.iterable.shade.org.apache.commons.configuration.ConfigurationException;
import com.iterable.shade.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.iterable.shade.org.apache.commons.configuration.EnvironmentConfiguration;
import com.iterable.shade.org.apache.commons.configuration.FileConfiguration;
import com.iterable.shade.org.apache.commons.configuration.FileSystem;
import com.iterable.shade.org.apache.commons.configuration.FileSystemBased;
import com.iterable.shade.org.apache.commons.configuration.HierarchicalConfiguration;
import com.iterable.shade.org.apache.commons.configuration.HierarchicalINIConfiguration;
import com.iterable.shade.org.apache.commons.configuration.JNDIConfiguration;
import com.iterable.shade.org.apache.commons.configuration.PropertiesConfiguration;
import com.iterable.shade.org.apache.commons.configuration.SubnodeConfiguration;
import com.iterable.shade.org.apache.commons.configuration.SystemConfiguration;
import com.iterable.shade.org.apache.commons.configuration.XMLConfiguration;
import com.iterable.shade.org.apache.commons.configuration.XMLPropertiesConfiguration;
import com.iterable.shade.org.apache.commons.configuration.beanutils.BeanDeclaration;
import com.iterable.shade.org.apache.commons.configuration.beanutils.BeanFactory;
import com.iterable.shade.org.apache.commons.configuration.beanutils.BeanHelper;
import com.iterable.shade.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import com.iterable.shade.org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import com.iterable.shade.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.iterable.shade.org.apache.commons.configuration.event.ConfigurationListener;
import com.iterable.shade.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.iterable.shade.org.apache.commons.configuration.resolver.CatalogResolver;
import com.iterable.shade.org.apache.commons.configuration.resolver.EntityRegistry;
import com.iterable.shade.org.apache.commons.configuration.resolver.EntityResolverSupport;
import com.iterable.shade.org.apache.commons.configuration.tree.ConfigurationNode;
import com.iterable.shade.org.apache.commons.configuration.tree.OverrideCombiner;
import com.iterable.shade.org.apache.commons.configuration.tree.UnionCombiner;
import com.iterable.shade.org.apache.commons.lang.text.StrLookup;
import com.iterable.shade.org.apache.commons.logging.Log;
import com.iterable.shade.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationBuilder
extends XMLConfiguration
implements ConfigurationBuilder {
    public static final String ADDITIONAL_NAME = DefaultConfigurationBuilder.class.getName() + "/ADDITIONAL_CONFIG";
    public static final int EVENT_ERR_LOAD_OPTIONAL = 51;
    static final String CONFIG_BEAN_FACTORY_NAME = DefaultConfigurationBuilder.class.getName() + ".CONFIG_BEAN_FACTORY_NAME";
    static final String ATTR_NAME = "[@config-name]";
    static final String ATTR_ATNAME = "at";
    static final String ATTR_AT_RES = "[@config-at]";
    static final String ATTR_AT = "[@at]";
    static final String ATTR_OPTIONALNAME = "optional";
    static final String ATTR_OPTIONAL_RES = "[@config-optional]";
    static final String ATTR_OPTIONAL = "[@optional]";
    static final String ATTR_FILENAME = "[@fileName]";
    static final String ATTR_FORCECREATE = "[@config-forceCreate]";
    static final String KEY_SYSTEM_PROPS = "[@systemProperties]";
    static final String SEC_HEADER = "header";
    static final String KEY_UNION = "additional";
    static final String[] CONFIG_SECTIONS = new String[]{"additional", "override", "header"};
    static final String KEY_OVERRIDE = "override";
    static final String KEY_OVERRIDE_LIST = "header.combiner.override.list-nodes.node";
    static final String KEY_ADDITIONAL_LIST = "header.combiner.additional.list-nodes.node";
    static final String KEY_CONFIGURATION_PROVIDERS = "header.providers.provider";
    static final String KEY_PROVIDER_KEY = "[@config-tag]";
    static final String KEY_CONFIGURATION_LOOKUPS = "header.lookups.lookup";
    static final String KEY_ENTITY_RESOLVER = "header.entity-resolver";
    static final String KEY_LOOKUP_KEY = "[@config-prefix]";
    static final String FILE_SYSTEM = "header.fileSystem";
    static final String KEY_RESULT = "header.result";
    static final String KEY_COMBINER = "header.result.nodeCombiner";
    static final String EXT_XML = ".xml";
    private static final ConfigurationProvider PROPERTIES_PROVIDER = new FileExtensionConfigurationProvider(XMLPropertiesConfiguration.class, PropertiesConfiguration.class, ".xml");
    private static final ConfigurationProvider XML_PROVIDER = new XMLConfigurationProvider();
    private static final ConfigurationProvider JNDI_PROVIDER = new ConfigurationProvider(JNDIConfiguration.class);
    private static final ConfigurationProvider SYSTEM_PROVIDER = new ConfigurationProvider(SystemConfiguration.class);
    private static final ConfigurationProvider INI_PROVIDER = new FileConfigurationProvider(HierarchicalINIConfiguration.class);
    private static final ConfigurationProvider ENV_PROVIDER = new ConfigurationProvider(EnvironmentConfiguration.class);
    private static final ConfigurationProvider PLIST_PROVIDER = new FileExtensionConfigurationProvider("com.iterable.shade.org.apache.commons.configuration.plist.XMLPropertyListConfiguration", "com.iterable.shade.org.apache.commons.configuration.plist.PropertyListConfiguration", ".xml");
    private static final ConfigurationProvider BUILDER_PROVIDER = new ConfigurationBuilderProvider();
    private static final String[] DEFAULT_TAGS = new String[]{"properties", "xml", "hierarchicalXml", "jndi", "system", "plist", "configuration", "ini", "env"};
    private static final ConfigurationProvider[] DEFAULT_PROVIDERS = new ConfigurationProvider[]{PROPERTIES_PROVIDER, XML_PROVIDER, XML_PROVIDER, JNDI_PROVIDER, SYSTEM_PROVIDER, PLIST_PROVIDER, BUILDER_PROVIDER, INI_PROVIDER, ENV_PROVIDER};
    private static final long serialVersionUID = -3113777854714492123L;
    private final StrLookup combinedConfigLookup = new StrLookup(){

        public String lookup(String key) {
            if (DefaultConfigurationBuilder.this.constructedConfiguration != null) {
                Object value = DefaultConfigurationBuilder.this.constructedConfiguration.resolveContainerStore(key);
                return value != null ? value.toString() : null;
            }
            return null;
        }
    };
    private CombinedConfiguration constructedConfiguration;
    private final Map<String, ConfigurationProvider> providers = new HashMap<String, ConfigurationProvider>();
    private String configurationBasePath;

    public DefaultConfigurationBuilder() {
        this.registerDefaultProviders();
        this.registerBeanFactory();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DefaultConfigurationBuilder(File file) {
        this();
        this.setFile(file);
    }

    public DefaultConfigurationBuilder(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
    }

    public DefaultConfigurationBuilder(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
    }

    public String getConfigurationBasePath() {
        return this.configurationBasePath != null ? this.configurationBasePath : this.getBasePath();
    }

    public void setConfigurationBasePath(String configurationBasePath) {
        this.configurationBasePath = configurationBasePath;
    }

    public void addConfigurationProvider(String tagName, ConfigurationProvider provider) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name must not be null!");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.providers.put(tagName, provider);
    }

    public ConfigurationProvider removeConfigurationProvider(String tagName) {
        return this.providers.remove(tagName);
    }

    public ConfigurationProvider providerForTag(String tagName) {
        return this.providers.get(tagName);
    }

    @Override
    public Configuration getConfiguration() throws ConfigurationException {
        return this.getConfiguration(true);
    }

    public CombinedConfiguration getConfiguration(boolean load) throws ConfigurationException {
        CombinedConfiguration result;
        if (load) {
            this.load();
        }
        this.initFileSystem();
        this.initSystemProperties();
        this.configureEntityResolver();
        this.registerConfiguredProviders();
        this.registerConfiguredLookups();
        this.constructedConfiguration = result = this.createResultConfiguration();
        List<SubnodeConfiguration> overrides = this.fetchTopLevelOverrideConfigs();
        overrides.addAll(this.fetchChildConfigs(KEY_OVERRIDE));
        this.initCombinedConfiguration(result, overrides, KEY_OVERRIDE_LIST);
        List<SubnodeConfiguration> additionals = this.fetchChildConfigs(KEY_UNION);
        if (!additionals.isEmpty()) {
            CombinedConfiguration addConfig = this.createAdditionalsConfiguration(result);
            result.addConfiguration(addConfig, ADDITIONAL_NAME);
            this.initCombinedConfiguration(addConfig, additionals, KEY_ADDITIONAL_LIST);
        }
        return result;
    }

    protected CombinedConfiguration createResultConfiguration() throws ConfigurationException {
        XMLBeanDeclaration decl = new XMLBeanDeclaration(this, KEY_RESULT, true);
        CombinedConfiguration result = (CombinedConfiguration)BeanHelper.createBean(decl, CombinedConfiguration.class);
        if (this.getMaxIndex(KEY_COMBINER) < 0) {
            result.setNodeCombiner(new OverrideCombiner());
        }
        return result;
    }

    protected CombinedConfiguration createAdditionalsConfiguration(CombinedConfiguration resultConfig) {
        CombinedConfiguration addConfig = new CombinedConfiguration(new UnionCombiner());
        addConfig.setDelimiterParsingDisabled(resultConfig.isDelimiterParsingDisabled());
        addConfig.setForceReloadCheck(resultConfig.isForceReloadCheck());
        addConfig.setIgnoreReloadExceptions(resultConfig.isIgnoreReloadExceptions());
        return addConfig;
    }

    protected void initCombinedConfiguration(CombinedConfiguration config, List<? extends HierarchicalConfiguration> containedConfigs, String keyListNodes) throws ConfigurationException {
        List<Object> listNodes = this.getList(keyListNodes);
        for (Object object : listNodes) {
            config.getNodeCombiner().addListNode((String)object);
        }
        for (HierarchicalConfiguration hierarchicalConfiguration : containedConfigs) {
            AbstractConfiguration newConf;
            ConfigurationDeclaration decl = new ConfigurationDeclaration(this, hierarchicalConfiguration);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating configuration " + decl.getBeanClassName() + " with name " + decl.getConfiguration().getString(ATTR_NAME));
            }
            if ((newConf = this.createConfigurationAt(decl)) == null) continue;
            config.addConfiguration(newConf, decl.getConfiguration().getString(ATTR_NAME), decl.getAt());
        }
    }

    protected void registerDefaultProviders() {
        for (int i = 0; i < DEFAULT_TAGS.length; ++i) {
            this.addConfigurationProvider(DEFAULT_TAGS[i], DEFAULT_PROVIDERS[i]);
        }
    }

    protected void registerConfiguredProviders() throws ConfigurationException {
        List<HierarchicalConfiguration> nodes = this.configurationsAt(KEY_CONFIGURATION_PROVIDERS);
        for (HierarchicalConfiguration config : nodes) {
            XMLBeanDeclaration decl = new XMLBeanDeclaration(config);
            String key = config.getString(KEY_PROVIDER_KEY);
            this.addConfigurationProvider(key, (ConfigurationProvider)BeanHelper.createBean(decl));
        }
    }

    protected void registerConfiguredLookups() throws ConfigurationException {
        List<HierarchicalConfiguration> nodes = this.configurationsAt(KEY_CONFIGURATION_LOOKUPS);
        for (HierarchicalConfiguration config : nodes) {
            XMLBeanDeclaration decl = new XMLBeanDeclaration(config);
            String key = config.getString(KEY_LOOKUP_KEY);
            StrLookup lookup = (StrLookup)BeanHelper.createBean(decl);
            BeanHelper.setProperty(lookup, "configuration", this);
            ConfigurationInterpolator.registerGlobalLookup(key, lookup);
            this.getInterpolator().registerLookup(key, lookup);
        }
    }

    protected void initFileSystem() throws ConfigurationException {
        if (this.getMaxIndex(FILE_SYSTEM) == 0) {
            SubnodeConfiguration config = this.configurationAt(FILE_SYSTEM);
            XMLBeanDeclaration decl = new XMLBeanDeclaration(config);
            this.setFileSystem((FileSystem)BeanHelper.createBean(decl));
        }
    }

    protected void initSystemProperties() throws ConfigurationException {
        String fileName = this.getString(KEY_SYSTEM_PROPS);
        if (fileName != null) {
            try {
                SystemConfiguration.setSystemProperties(this.getConfigurationBasePath(), fileName);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Error setting system properties from " + fileName, ex);
            }
        }
    }

    protected void configureEntityResolver() throws ConfigurationException {
        if (this.getMaxIndex(KEY_ENTITY_RESOLVER) == 0) {
            XMLBeanDeclaration decl = new XMLBeanDeclaration(this, KEY_ENTITY_RESOLVER, true);
            EntityResolver resolver = (EntityResolver)BeanHelper.createBean(decl, CatalogResolver.class);
            BeanHelper.setProperty(resolver, "fileSystem", this.getFileSystem());
            BeanHelper.setProperty(resolver, "baseDir", this.getBasePath());
            BeanHelper.setProperty(resolver, "substitutor", this.getSubstitutor());
            this.setEntityResolver(resolver);
        }
    }

    @Override
    protected Object interpolate(Object value) {
        Object result = super.interpolate(value);
        if (this.constructedConfiguration != null) {
            result = this.constructedConfiguration.interpolate(result);
        }
        return result;
    }

    private AbstractConfiguration createConfigurationAt(ConfigurationDeclaration decl) throws ConfigurationException {
        try {
            return (AbstractConfiguration)BeanHelper.createBean(decl);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    private List<SubnodeConfiguration> fetchChildConfigs(ConfigurationNode node) {
        List<ConfigurationNode> children = node.getChildren();
        ArrayList<SubnodeConfiguration> result = new ArrayList<SubnodeConfiguration>(children.size());
        for (ConfigurationNode child : children) {
            result.add(this.createSubnodeConfiguration(child));
        }
        return result;
    }

    private List<SubnodeConfiguration> fetchChildConfigs(String key) {
        List<ConfigurationNode> nodes = this.fetchNodeList(key);
        if (nodes.size() > 0) {
            return this.fetchChildConfigs(nodes.get(0));
        }
        return Collections.emptyList();
    }

    private List<SubnodeConfiguration> fetchTopLevelOverrideConfigs() {
        List<SubnodeConfiguration> configs = this.fetchChildConfigs(this.getRootNode());
        Iterator<SubnodeConfiguration> it = configs.iterator();
        block0: while (it.hasNext()) {
            String nodeName = it.next().getRootNode().getName();
            for (int i = 0; i < CONFIG_SECTIONS.length; ++i) {
                if (!CONFIG_SECTIONS[i].equals(nodeName)) continue;
                it.remove();
                continue block0;
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeanFactory() {
        Class<DefaultConfigurationBuilder> clazz = DefaultConfigurationBuilder.class;
        synchronized (DefaultConfigurationBuilder.class) {
            if (!BeanHelper.registeredFactoryNames().contains(CONFIG_BEAN_FACTORY_NAME)) {
                BeanHelper.registerBeanFactory(CONFIG_BEAN_FACTORY_NAME, new ConfigurationBeanFactory());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static class ConfigurationBuilderProvider
    extends ConfigurationProvider {
        public ConfigurationBuilderProvider() {
            super(DefaultConfigurationBuilder.class);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            DefaultConfigurationBuilder builder = (DefaultConfigurationBuilder)super.getConfiguration(decl);
            return builder.getConfiguration(true);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            return new CombinedConfiguration();
        }

        protected void initBeanInstance(Object bean, BeanDeclaration data) throws Exception {
            ConfigurationDeclaration decl = (ConfigurationDeclaration)data;
            ConfigurationBuilderProvider.initChildBuilder(decl.getConfigurationBuilder(), (DefaultConfigurationBuilder)bean);
            super.initBeanInstance(bean, data);
        }

        private static void initChildBuilder(DefaultConfigurationBuilder parent, DefaultConfigurationBuilder child) {
            child.setAttributeSplittingDisabled(parent.isAttributeSplittingDisabled());
            child.setBasePath(parent.getBasePath());
            child.setDelimiterParsingDisabled(parent.isDelimiterParsingDisabled());
            child.setListDelimiter(parent.getListDelimiter());
            child.setThrowExceptionOnMissing(parent.isThrowExceptionOnMissing());
            child.setLogger(parent.getLogger());
            child.clearConfigurationListeners();
            for (ConfigurationListener configurationListener : parent.getConfigurationListeners()) {
                child.addConfigurationListener(configurationListener);
            }
            child.clearErrorListeners();
            for (ConfigurationErrorListener configurationErrorListener : parent.getErrorListeners()) {
                child.addErrorListener(configurationErrorListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileExtensionConfigurationProvider
    extends FileConfigurationProvider {
        private Class<?> matchingClass;
        private String matchingClassName;
        private Class<?> defaultClass;
        private String defaultClassName;
        private String fileExtension;

        public FileExtensionConfigurationProvider(Class<?> matchingClass, Class<?> defaultClass, String extension) {
            this.matchingClass = matchingClass;
            this.defaultClass = defaultClass;
            this.fileExtension = extension;
        }

        public FileExtensionConfigurationProvider(String matchingClassName, String defaultClassName, String extension) {
            this.matchingClassName = matchingClassName;
            this.defaultClassName = defaultClassName;
            this.fileExtension = extension;
        }

        protected synchronized Class<?> fetchMatchingClass() throws Exception {
            if (this.matchingClass == null) {
                this.matchingClass = this.loadClass(this.matchingClassName);
            }
            return this.matchingClass;
        }

        protected synchronized Class<?> fetchDefaultClass() throws Exception {
            if (this.defaultClass == null) {
                this.defaultClass = this.loadClass(this.defaultClassName);
            }
            return this.defaultClass;
        }

        @Override
        protected Object createBeanInstance(Class<?> beanClass, BeanDeclaration data) throws Exception {
            String fileName = ((ConfigurationDeclaration)data).getConfiguration().getString(DefaultConfigurationBuilder.ATTR_FILENAME);
            if (fileName != null && fileName.toLowerCase().trim().endsWith(this.fileExtension)) {
                return super.createBeanInstance(this.fetchMatchingClass(), data);
            }
            return super.createBeanInstance(this.fetchDefaultClass(), data);
        }
    }

    public static class XMLConfigurationProvider
    extends FileConfigurationProvider {
        public XMLConfigurationProvider() {
            super(XMLConfiguration.class);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            XMLConfiguration config = (XMLConfiguration)super.getEmptyConfiguration(decl);
            DefaultConfigurationBuilder builder = decl.getConfigurationBuilder();
            EntityResolver resolver = builder.getEntityResolver();
            if (resolver instanceof EntityRegistry) {
                config.getRegisteredEntities().putAll(builder.getRegisteredEntities());
            } else {
                config.setEntityResolver(resolver);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileConfigurationProvider
    extends ConfigurationProvider {
        public FileConfigurationProvider() {
        }

        public FileConfigurationProvider(Class<?> configClass) {
            super(configClass);
        }

        public FileConfigurationProvider(String configClassName) {
            super(configClassName);
        }

        @Override
        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            DefaultConfigurationBuilder builder;
            AbstractConfiguration result = this.getEmptyConfiguration(decl);
            if (result instanceof FileSystemBased && (builder = decl.getConfigurationBuilder()).getFileSystem() != null) {
                ((FileSystemBased)((Object)result)).setFileSystem(builder.getFileSystem());
            }
            ((FileConfiguration)((Object)result)).load();
            return result;
        }

        @Override
        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            AbstractConfiguration config = super.getConfiguration(decl);
            if (config instanceof EntityResolverSupport) {
                DefaultConfigurationBuilder builder = decl.getConfigurationBuilder();
                EntityResolver resolver = builder.getEntityResolver();
                ((EntityResolverSupport)((Object)config)).setEntityResolver(resolver);
            }
            return config;
        }

        @Override
        protected void initBeanInstance(Object bean, BeanDeclaration data) throws Exception {
            FileConfiguration config = (FileConfiguration)bean;
            config.setBasePath(((ConfigurationDeclaration)data).getConfigurationBuilder().getConfigurationBasePath());
            super.initBeanInstance(bean, data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConfigurationBeanFactory
    implements BeanFactory {
        private Log logger = LogFactory.getLog(DefaultConfigurationBuilder.class);

        ConfigurationBeanFactory() {
        }

        @Override
        public Object createBean(Class<?> beanClass, BeanDeclaration data, Object param) throws Exception {
            ConfigurationDeclaration decl = (ConfigurationDeclaration)data;
            String tagName = decl.getNode().getName();
            ConfigurationProvider provider = decl.getConfigurationBuilder().providerForTag(tagName);
            if (provider == null) {
                throw new ConfigurationRuntimeException("No ConfigurationProvider registered for tag " + tagName);
            }
            try {
                AbstractConfiguration config = provider.getConfiguration(decl);
                this.installInterpolator(decl, config);
                return config;
            }
            catch (Exception ex) {
                if (!decl.isOptional()) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Load failed for optional configuration " + tagName + ": " + ex.getMessage());
                }
                decl.getConfigurationBuilder().fireError(51, decl.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_NAME), null, ex);
                if (decl.isForceCreate()) {
                    try {
                        return provider.getEmptyConfiguration(decl);
                    }
                    catch (Exception ex2) {
                        this.logger.warn("Could not create instance of optional configuration " + tagName, ex2);
                    }
                }
                return null;
            }
        }

        @Override
        public Class<?> getDefaultBeanClass() {
            return Configuration.class;
        }

        private void installInterpolator(ConfigurationDeclaration decl, AbstractConfiguration config) {
            ConfigurationInterpolator parent = new ConfigurationInterpolator();
            parent.setDefaultLookup(decl.getConfigurationBuilder().combinedConfigLookup);
            config.getInterpolator().setParentInterpolator(parent);
        }
    }

    public static class ConfigurationDeclaration
    extends XMLBeanDeclaration {
        private DefaultConfigurationBuilder configurationBuilder;

        public ConfigurationDeclaration(DefaultConfigurationBuilder builder, HierarchicalConfiguration config) {
            super(config);
            this.configurationBuilder = builder;
        }

        public DefaultConfigurationBuilder getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public String getAt() {
            String result = this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT_RES);
            return result == null ? this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT) : result;
        }

        public boolean isOptional() {
            Boolean value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL_RES, null);
            if (value == null) {
                value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL, Boolean.FALSE);
            }
            return value;
        }

        public boolean isForceCreate() {
            return this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_FORCECREATE, false);
        }

        public String getBeanFactoryName() {
            return CONFIG_BEAN_FACTORY_NAME;
        }

        public String getBeanClassName() {
            return null;
        }

        protected boolean isReservedNode(ConfigurationNode nd) {
            if (super.isReservedNode(nd)) {
                return true;
            }
            return nd.isAttribute() && (DefaultConfigurationBuilder.ATTR_ATNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-at") == 0 || DefaultConfigurationBuilder.ATTR_OPTIONALNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-optional") == 0);
        }

        protected Object interpolate(Object value) {
            return this.getConfigurationBuilder().interpolate(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationProvider
    extends DefaultBeanFactory {
        private Class<?> configurationClass;
        private String configurationClassName;

        public ConfigurationProvider() {
            this((Class)null);
        }

        public ConfigurationProvider(Class<?> configClass) {
            this.setConfigurationClass(configClass);
        }

        public ConfigurationProvider(String configClassName) {
            this.setConfigurationClassName(configClassName);
        }

        public Class<?> getConfigurationClass() {
            return this.configurationClass;
        }

        public void setConfigurationClass(Class<?> configurationClass) {
            this.configurationClass = configurationClass;
        }

        public String getConfigurationClassName() {
            return this.configurationClassName;
        }

        public void setConfigurationClassName(String configurationClassName) {
            this.configurationClassName = configurationClassName;
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            return (AbstractConfiguration)this.createBean(this.fetchConfigurationClass(), decl, null);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            return null;
        }

        protected synchronized Class<?> fetchConfigurationClass() throws Exception {
            if (this.getConfigurationClass() == null) {
                this.setConfigurationClass(this.loadClass(this.getConfigurationClassName()));
            }
            return this.getConfigurationClass();
        }

        protected Class<?> loadClass(String className) throws ClassNotFoundException {
            return className != null ? Class.forName(className, true, this.getClass().getClassLoader()) : null;
        }
    }
}

