/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.bookkeeper.common.util.affinity.impl;

import com.iterable.shade.org.apache.bookkeeper.common.util.affinity.impl.CpuAffinityJni;
import com.iterable.shade.org.apache.bookkeeper.common.util.affinity.impl.IsolatedProcessors;
import com.iterable.shade.org.apache.bookkeeper.common.util.affinity.impl.NativeUtils;
import com.iterable.shade.org.apache.bookkeeper.common.util.affinity.impl.ProcessorsInfo;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpuAffinityImpl {
    private static final Logger log = LoggerFactory.getLogger(CpuAffinityImpl.class);
    private static boolean isInitialized = false;
    private static boolean isSupported;
    private static final SortedSet<Integer> acquiredProcessors;
    private static SortedSet<Integer> isolatedProcessors;
    private static ProcessorsInfo processorsInfo;
    private static final String LOCK_FILE_PREFIX;

    public static synchronized void acquireCore() {
        if (!isInitialized) {
            CpuAffinityImpl.init();
        }
        if (!isSupported) {
            throw new RuntimeException("CPU Affinity not supported in current environment");
        }
        if (!CpuAffinityJni.isRoot()) {
            throw new RuntimeException("CPU Affinity can only be set if the process is running as root");
        }
        try {
            int cpu = CpuAffinityImpl.pickAvailableCpu();
            CpuAffinityJni.setAffinity(cpu);
            log.info("Thread {} has successfully acquired ownership of cpu {}", (Object)Thread.currentThread().getName(), (Object)cpu);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to acquire CPU core: " + e.getMessage());
        }
    }

    private static synchronized int pickAvailableCpu() throws IOException {
        if (isolatedProcessors == null) {
            isolatedProcessors = IsolatedProcessors.get();
        }
        Iterator iterator = isolatedProcessors.iterator();
        while (iterator.hasNext()) {
            int isolatedCpu = (Integer)iterator.next();
            if (log.isDebugEnabled()) {
                log.debug("Checking CPU {}", (Object)isolatedCpu);
            }
            if (acquiredProcessors.contains(isolatedCpu)) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Ignoring CPU {} since it's already acquired", (Object)isolatedCpu);
                continue;
            }
            if (!CpuAffinityImpl.tryAcquireCpu(isolatedCpu)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Using CPU {}", (Object)isolatedCpu);
            }
            return isolatedCpu;
        }
        throw new RuntimeException("There is no available isolated CPU to acquire for thread " + Thread.currentThread().getName());
    }

    private static boolean tryAcquireCpu(int targetCpu) throws IOException {
        if (processorsInfo == null) {
            processorsInfo = ProcessorsInfo.parseCpuInfo();
        }
        Set<Integer> cpusToAcquire = processorsInfo.getCpusOnSameCore(targetCpu);
        ArrayList<Closeable> acquiredCpus = new ArrayList<Closeable>();
        for (int cpu : cpusToAcquire) {
            Closeable lock = CpuAffinityImpl.tryAcquireFileLock(cpu);
            if (lock == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to acquire lock on CPU {}", (Object)cpu);
                }
                for (Closeable l : acquiredCpus) {
                    l.close();
                }
                return false;
            }
            acquiredCpus.add(lock);
        }
        for (int cpu : cpusToAcquire) {
            if (cpu == targetCpu) {
                IsolatedProcessors.enableCpu(cpu);
            } else {
                IsolatedProcessors.disableCpu(cpu);
            }
            acquiredProcessors.add(cpu);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Closeable tryAcquireFileLock(int cpu) throws IOException {
        String lockPath = LOCK_FILE_PREFIX + cpu;
        RandomAccessFile file = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            file = new RandomAccessFile(new File(lockPath), "rw");
            channel = file.getChannel();
            lock = ((FileChannel)channel).tryLock();
            if (lock == null) {
                Closeable closeable = null;
                return closeable;
            }
            FileLock finalLock = lock;
            AbstractInterruptibleChannel finalChannel = channel;
            RandomAccessFile finalFile = file;
            Closeable closeable = () -> CpuAffinityImpl.lambda$tryAcquireFileLock$0(finalLock, (FileChannel)finalChannel, finalFile);
            return closeable;
        }
        finally {
            if (lock == null) {
                if (channel != null) {
                    channel.close();
                }
                if (file != null) {
                    file.close();
                }
            }
        }
    }

    private static void init() {
        try {
            NativeUtils.loadLibraryFromJar("/lib/libcpu-affinity.so");
            isSupported = CpuAffinityJni.isAvailable();
        }
        catch (Exception | UnsatisfiedLinkError e) {
            log.warn("Unable to load CPU affinity library: {}", (Object)e.getMessage(), (Object)e);
            isSupported = false;
        }
        finally {
            isInitialized = true;
        }
    }

    private CpuAffinityImpl() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$tryAcquireFileLock$0(FileLock finalLock, FileChannel finalChannel, RandomAccessFile finalFile) throws IOException {
        finalLock.close();
        finalChannel.close();
        finalFile.close();
    }

    static {
        acquiredProcessors = new TreeSet<Integer>();
        isolatedProcessors = null;
        processorsInfo = null;
        LOCK_FILE_PREFIX = Paths.get(System.getProperty("java.io.tmpdir"), "cpu-lock-").toString();
    }
}

