/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.bookkeeper.common.allocator.impl;

import com.iterable.shade.io.netty.buffer.ByteBufAllocator;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.PoolingPolicy;
import com.iterable.shade.org.apache.bookkeeper.common.allocator.impl.ByteBufAllocatorImpl;
import java.util.function.Consumer;

public class ByteBufAllocatorBuilderImpl
implements ByteBufAllocatorBuilder {
    ByteBufAllocator pooledAllocator = null;
    ByteBufAllocator unpooledAllocator = null;
    PoolingPolicy poolingPolicy = PoolingPolicy.PooledDirect;
    int poolingConcurrency = 2 * Runtime.getRuntime().availableProcessors();
    OutOfMemoryPolicy outOfMemoryPolicy = OutOfMemoryPolicy.FallbackToHeap;
    Consumer<OutOfMemoryError> outOfMemoryListener = null;
    LeakDetectionPolicy leakDetectionPolicy = LeakDetectionPolicy.Disabled;

    @Override
    public ByteBufAllocatorWithOomHandler build() {
        return new ByteBufAllocatorImpl(this.pooledAllocator, this.unpooledAllocator, this.poolingPolicy, this.poolingConcurrency, this.outOfMemoryPolicy, this.outOfMemoryListener, this.leakDetectionPolicy);
    }

    @Override
    public ByteBufAllocatorBuilder pooledAllocator(ByteBufAllocator pooledAllocator) {
        this.pooledAllocator = pooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder unpooledAllocator(ByteBufAllocator unpooledAllocator) {
        this.unpooledAllocator = unpooledAllocator;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingPolicy(PoolingPolicy policy) {
        this.poolingPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder poolingConcurrency(int poolingConcurrency) {
        this.poolingConcurrency = poolingConcurrency;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryPolicy(OutOfMemoryPolicy policy) {
        this.outOfMemoryPolicy = policy;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder outOfMemoryListener(Consumer<OutOfMemoryError> listener) {
        this.outOfMemoryListener = listener;
        return this;
    }

    @Override
    public ByteBufAllocatorBuilder leakDetectionPolicy(LeakDetectionPolicy leakDetectionPolicy) {
        this.leakDetectionPolicy = leakDetectionPolicy;
        return this;
    }
}

