/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.bookkeeper.common.allocator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LeakDetectionPolicy {
    Disabled,
    Simple,
    Advanced,
    Paranoid;

    private static final Logger log;

    public static LeakDetectionPolicy parseLevel(String levelStr) {
        String trimmedLevelStr = levelStr.trim();
        for (LeakDetectionPolicy policy : LeakDetectionPolicy.values()) {
            if (!trimmedLevelStr.equalsIgnoreCase(policy.name())) continue;
            return policy;
        }
        log.warn("Parse leak detection policy level {} failed. Use the default level: {}", (Object)levelStr, (Object)Disabled.name());
        return Disabled;
    }

    static {
        log = LoggerFactory.getLogger(LeakDetectionPolicy.class);
    }
}

