/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.org.apache.avro.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.iterable.shade.com.fasterxml.jackson.core.JsonFactory;
import com.iterable.shade.com.fasterxml.jackson.databind.JsonNode;
import com.iterable.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.iterable.shade.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.iterable.shade.org.apache.avro.Conversion;
import com.iterable.shade.org.apache.avro.Schema;
import com.iterable.shade.org.apache.avro.generic.GenericData;
import com.iterable.shade.org.apache.avro.io.DatumReader;
import com.iterable.shade.org.apache.avro.io.DatumWriter;
import com.iterable.shade.org.apache.avro.protobuf.ProtobufDatumReader;
import com.iterable.shade.org.apache.avro.protobuf.ProtobufDatumWriter;
import com.iterable.shade.org.apache.avro.specific.SpecificData;
import com.iterable.shade.org.apache.avro.util.ClassUtils;
import com.iterable.shade.org.apache.avro.util.internal.Accessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtobufData
extends GenericData {
    private static final ProtobufData INSTANCE = new ProtobufData();
    private final Map<Descriptors.Descriptor, Descriptors.FieldDescriptor[]> fieldCache = new ConcurrentHashMap<Descriptors.Descriptor, Descriptors.FieldDescriptor[]>();
    private final Map<Object, Schema> schemaCache = new ConcurrentHashMap<Object, Schema>();
    private static final ThreadLocal<Map<Descriptors.Descriptor, Schema>> SEEN = ThreadLocal.withInitial(IdentityHashMap::new);
    private static final Schema NULL = Schema.create(Schema.Type.NULL);
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static final JsonNodeFactory NODES = JsonNodeFactory.instance;

    protected ProtobufData() {
    }

    public static ProtobufData get() {
        return INSTANCE;
    }

    @Override
    public DatumReader createDatumReader(Schema schema) {
        return new ProtobufDatumReader(schema, schema, this);
    }

    @Override
    public DatumWriter createDatumWriter(Schema schema) {
        return new ProtobufDatumWriter(schema, this);
    }

    @Override
    public void setField(Object r, String n, int pos, Object value) {
        this.setField(r, n, pos, value, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    @Override
    public Object getField(Object r, String name, int pos) {
        return this.getField(r, name, pos, this.getRecordState(r, this.getSchema(r.getClass())));
    }

    @Override
    protected void setField(Object record, String name, int position, Object value, Object state) {
        Message.Builder b = (Message.Builder)record;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[position];
        switch (f.getType()) {
            case MESSAGE: {
                if (value == null) {
                    b.clearField(f);
                    break;
                }
            }
            default: {
                b.setField(f, value);
            }
        }
    }

    @Override
    protected Object getField(Object record, String name, int pos, Object state) {
        Message m4 = (Message)record;
        Descriptors.FieldDescriptor f = ((Descriptors.FieldDescriptor[])state)[pos];
        switch (f.getType()) {
            case MESSAGE: {
                if (f.isRepeated() || m4.hasField(f)) break;
                return null;
            }
        }
        return m4.getField(f);
    }

    @Override
    protected Object getRecordState(Object r, Schema s2) {
        Descriptors.Descriptor d = ((MessageOrBuilder)r).getDescriptorForType();
        Descriptors.FieldDescriptor[] fields = this.fieldCache.get(d);
        if (fields == null) {
            fields = new Descriptors.FieldDescriptor[s2.getFields().size()];
            for (Schema.Field f : s2.getFields()) {
                fields[f.pos()] = d.findFieldByName(f.name());
            }
            this.fieldCache.put(d, fields);
        }
        return fields;
    }

    @Override
    protected boolean isRecord(Object datum) {
        return datum instanceof Message;
    }

    @Override
    public Object newRecord(Object old, Schema schema) {
        try {
            Class c = SpecificData.get().getClass(schema);
            if (c == null) {
                return super.newRecord(old, schema);
            }
            if (c.isInstance(old)) {
                return old;
            }
            return c.getMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isArray(Object datum) {
        return datum instanceof List;
    }

    @Override
    protected boolean isBytes(Object datum) {
        return datum instanceof ByteString;
    }

    @Override
    protected Schema getRecordSchema(Object record) {
        Descriptors.Descriptor descriptor = ((Message)record).getDescriptorForType();
        Schema schema = this.schemaCache.get(descriptor);
        if (schema == null) {
            schema = this.getSchema(descriptor);
            this.schemaCache.put(descriptor, schema);
        }
        return schema;
    }

    public Schema getSchema(Class c) {
        Schema schema = this.schemaCache.get(c);
        if (schema == null) {
            try {
                Object descriptor = c.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
                schema = c.isEnum() ? this.getSchema((Descriptors.EnumDescriptor)descriptor) : this.getSchema((Descriptors.Descriptor)descriptor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.schemaCache.put(c, schema);
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(Descriptors.Descriptor descriptor) {
        Map<Descriptors.Descriptor, Schema> seen = SEEN.get();
        if (seen.containsKey(descriptor)) {
            return seen.get(descriptor);
        }
        boolean first = seen.isEmpty();
        Conversion conversion = this.getConversionByDescriptor(descriptor);
        if (conversion != null) {
            Schema converted = conversion.getRecommendedSchema();
            seen.put(descriptor, converted);
            return converted;
        }
        try {
            Schema result = Schema.createRecord(descriptor.getName(), null, this.getNamespace(descriptor.getFile(), descriptor.getContainingType()), false);
            seen.put(descriptor, result);
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(descriptor.getFields().size());
            for (Descriptors.FieldDescriptor f : descriptor.getFields()) {
                fields.add(Accessor.createField(f.getName(), this.getSchema(f), null, this.getDefault(f)));
            }
            result.setFields(fields);
            Schema schema = result;
            return schema;
        }
        finally {
            if (first) {
                seen.clear();
            }
        }
    }

    public String getNamespace(Descriptors.FileDescriptor fd, Descriptors.Descriptor containing) {
        DescriptorProtos.FileOptions o = fd.getOptions();
        String p = o.hasJavaPackage() ? o.getJavaPackage() : fd.getPackage();
        String outer = "";
        if (!o.getJavaMultipleFiles()) {
            if (o.hasJavaOuterClassname()) {
                outer = o.getJavaOuterClassname();
            } else {
                outer = new File(fd.getName()).getName();
                outer = outer.substring(0, outer.lastIndexOf(46));
                outer = ProtobufData.toCamelCase(outer);
            }
        }
        StringBuilder inner = new StringBuilder();
        while (containing != null) {
            if (inner.length() == 0) {
                inner.insert(0, containing.getName());
            } else {
                inner.insert(0, containing.getName() + "$");
            }
            containing = containing.getContainingType();
        }
        String d1 = !outer.isEmpty() || inner.length() != 0 ? "." : "";
        String d2 = !outer.isEmpty() && inner.length() != 0 ? "$" : "";
        return p + d1 + outer + d2 + inner;
    }

    private static String toCamelCase(String s2) {
        String[] parts = s2.split("_");
        StringBuilder camelCaseString = new StringBuilder(s2.length());
        for (String part : parts) {
            camelCaseString.append(ProtobufData.cap(part));
        }
        return camelCaseString.toString();
    }

    private static String cap(String s2) {
        return s2.substring(0, 1).toUpperCase() + s2.substring(1).toLowerCase();
    }

    public Schema getSchema(Descriptors.FieldDescriptor f) {
        Schema s2 = this.getNonRepeatedSchema(f);
        if (f.isRepeated()) {
            s2 = Schema.createArray(s2);
        }
        return s2;
    }

    private Schema getNonRepeatedSchema(Descriptors.FieldDescriptor f) {
        switch (f.getType()) {
            case BOOL: {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case FLOAT: {
                return Schema.create(Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create(Schema.Type.DOUBLE);
            }
            case STRING: {
                Schema s2 = Schema.create(Schema.Type.STRING);
                GenericData.setStringType(s2, GenericData.StringType.String);
                return s2;
            }
            case BYTES: {
                return Schema.create(Schema.Type.BYTES);
            }
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: {
                return Schema.create(Schema.Type.INT);
            }
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return Schema.create(Schema.Type.LONG);
            }
            case ENUM: {
                return this.getSchema(f.getEnumType());
            }
            case MESSAGE: {
                Schema result = this.getSchema(f.getMessageType());
                if (f.isOptional()) {
                    result = Schema.createUnion(Arrays.asList(NULL, result));
                }
                return result;
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }

    public Schema getSchema(Descriptors.EnumDescriptor d) {
        ArrayList<String> symbols = new ArrayList<String>(d.getValues().size());
        for (Descriptors.EnumValueDescriptor e : d.getValues()) {
            symbols.add(e.getName());
        }
        return Schema.createEnum(d.getName(), null, this.getNamespace(d.getFile(), d.getContainingType()), symbols);
    }

    private JsonNode getDefault(Descriptors.FieldDescriptor f) {
        if (f.isRequired()) {
            return null;
        }
        if (f.isRepeated()) {
            return NODES.arrayNode();
        }
        if (f.hasDefaultValue()) {
            Object value = f.getDefaultValue();
            switch (f.getType()) {
                case ENUM: {
                    value = ((Descriptors.EnumValueDescriptor)value).getName();
                }
            }
            String json = this.toString(value);
            try {
                return (JsonNode)MAPPER.readTree(FACTORY.createParser(json));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        switch (f.getType()) {
            case BOOL: {
                return NODES.booleanNode(false);
            }
            case FLOAT: {
                return NODES.numberNode(0.0f);
            }
            case DOUBLE: {
                return NODES.numberNode(0.0);
            }
            case INT32: 
            case UINT32: 
            case SINT32: 
            case FIXED32: 
            case SFIXED32: 
            case INT64: 
            case UINT64: 
            case SINT64: 
            case FIXED64: 
            case SFIXED64: {
                return NODES.numberNode(0);
            }
            case STRING: 
            case BYTES: {
                return NODES.textNode("");
            }
            case ENUM: {
                return NODES.textNode(((Descriptors.EnumValueDescriptor)f.getEnumType().getValues().get(0)).getName());
            }
            case MESSAGE: {
                return NODES.nullNode();
            }
        }
        throw new RuntimeException("Unexpected type: " + f.getType());
    }

    private Conversion getConversionByDescriptor(Descriptors.Descriptor descriptor) {
        String namespace = this.getNamespace(descriptor.getFile(), descriptor.getContainingType());
        String name = descriptor.getName();
        String dot = namespace.endsWith("$") ? "" : ".";
        try {
            Class<?> clazz = ClassUtils.forName(this.getClassLoader(), namespace + dot + name);
            return this.getConversionByClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

