/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.javassist.tools.reflect;

import com.iterable.shade.javassist.CannotCompileException;
import com.iterable.shade.javassist.ClassPool;
import com.iterable.shade.javassist.CodeConverter;
import com.iterable.shade.javassist.CtClass;
import com.iterable.shade.javassist.CtField;
import com.iterable.shade.javassist.CtMethod;
import com.iterable.shade.javassist.CtNewMethod;
import com.iterable.shade.javassist.Modifier;
import com.iterable.shade.javassist.NotFoundException;
import com.iterable.shade.javassist.Translator;
import com.iterable.shade.javassist.bytecode.BadBytecode;
import com.iterable.shade.javassist.bytecode.ClassFile;
import com.iterable.shade.javassist.bytecode.MethodInfo;
import com.iterable.shade.javassist.tools.reflect.CannotReflectException;

public class Reflection
implements Translator {
    static final String classobjectField = "_classobject";
    static final String classobjectAccessor = "_getClass";
    static final String metaobjectField = "_metaobject";
    static final String metaobjectGetter = "_getMetaobject";
    static final String metaobjectSetter = "_setMetaobject";
    static final String readPrefix = "_r_";
    static final String writePrefix = "_w_";
    static final String metaobjectClassName = "com.iterable.shade.javassist.tools.reflect.Metaobject";
    static final String classMetaobjectClassName = "com.iterable.shade.javassist.tools.reflect.ClassMetaobject";
    protected CtMethod trapMethod;
    protected CtMethod trapStaticMethod;
    protected CtMethod trapRead;
    protected CtMethod trapWrite;
    protected CtClass[] readParam;
    protected ClassPool classPool = null;
    protected CodeConverter converter = new CodeConverter();

    private boolean isExcluded(String name) {
        return name.startsWith("_m_") || name.equals(classobjectAccessor) || name.equals(metaobjectSetter) || name.equals(metaobjectGetter) || name.startsWith(readPrefix) || name.startsWith(writePrefix);
    }

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        String msg = "com.iterable.shade.javassist.tools.reflect.Sample is not found or broken.";
        try {
            CtClass c = this.classPool.get("com.iterable.shade.javassist.tools.reflect.Sample");
            this.rebuildClassFile(c.getClassFile());
            this.trapMethod = c.getDeclaredMethod("trap");
            this.trapStaticMethod = c.getDeclaredMethod("trapStatic");
            this.trapRead = c.getDeclaredMethod("trapRead");
            this.trapWrite = c.getDeclaredMethod("trapWrite");
            this.readParam = new CtClass[]{this.classPool.get("java.lang.Object")};
        }
        catch (NotFoundException e) {
            throw new RuntimeException("com.iterable.shade.javassist.tools.reflect.Sample is not found or broken.");
        }
        catch (BadBytecode e) {
            throw new RuntimeException("com.iterable.shade.javassist.tools.reflect.Sample is not found or broken.");
        }
    }

    @Override
    public void onLoad(ClassPool pool, String classname) throws CannotCompileException, NotFoundException {
        CtClass clazz = pool.get(classname);
        clazz.instrument(this.converter);
    }

    public boolean makeReflective(String classname, String metaobject, String metaclass) throws CannotCompileException, NotFoundException {
        return this.makeReflective(this.classPool.get(classname), this.classPool.get(metaobject), this.classPool.get(metaclass));
    }

    public boolean makeReflective(Class<?> clazz, Class<?> metaobject, Class<?> metaclass) throws CannotCompileException, NotFoundException {
        return this.makeReflective(clazz.getName(), metaobject.getName(), metaclass.getName());
    }

    public boolean makeReflective(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, CannotReflectException, NotFoundException {
        if (clazz.isInterface()) {
            throw new CannotReflectException("Cannot reflect an interface: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(classMetaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of ClassMetaobject: " + clazz.getName());
        }
        if (clazz.subclassOf(this.classPool.get(metaobjectClassName))) {
            throw new CannotReflectException("Cannot reflect a subclass of Metaobject: " + clazz.getName());
        }
        this.registerReflectiveClass(clazz);
        return this.modifyClassfile(clazz, metaobject, metaclass);
    }

    private void registerReflectiveClass(CtClass clazz) {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            CtField f = fs[i];
            int mod = f.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = f.getName();
            this.converter.replaceFieldRead(f, clazz, readPrefix + name);
            this.converter.replaceFieldWrite(f, clazz, writePrefix + name);
        }
    }

    private boolean modifyClassfile(CtClass clazz, CtClass metaobject, CtClass metaclass) throws CannotCompileException, NotFoundException {
        CtField f;
        boolean addMeta;
        if (clazz.getAttribute("Reflective") != null) {
            return false;
        }
        clazz.setAttribute("Reflective", new byte[0]);
        CtClass mlevel = this.classPool.get("com.iterable.shade.javassist.tools.reflect.Metalevel");
        boolean bl = addMeta = !clazz.subtypeOf(mlevel);
        if (addMeta) {
            clazz.addInterface(mlevel);
        }
        this.processMethods(clazz, addMeta);
        this.processFields(clazz);
        if (addMeta) {
            f = new CtField(this.classPool.get(metaobjectClassName), metaobjectField, clazz);
            f.setModifiers(4);
            clazz.addField(f, CtField.Initializer.byNewWithParams(metaobject));
            clazz.addMethod(CtNewMethod.getter(metaobjectGetter, f));
            clazz.addMethod(CtNewMethod.setter(metaobjectSetter, f));
        }
        f = new CtField(this.classPool.get(classMetaobjectClassName), classobjectField, clazz);
        f.setModifiers(10);
        clazz.addField(f, CtField.Initializer.byNew(metaclass, new String[]{clazz.getName()}));
        clazz.addMethod(CtNewMethod.getter(classobjectAccessor, f));
        return true;
    }

    private void processMethods(CtClass clazz, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod[] ms = clazz.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            CtMethod m4 = ms[i];
            int mod = m4.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isAbstract(mod)) continue;
            this.processMethods0(mod, clazz, m4, i, dontSearch);
        }
    }

    private void processMethods0(int mod, CtClass clazz, CtMethod m4, int identifier, boolean dontSearch) throws CannotCompileException, NotFoundException {
        CtMethod m22;
        String name = m4.getName();
        if (this.isExcluded(name)) {
            return;
        }
        if (m4.getDeclaringClass() == clazz) {
            if (Modifier.isNative(mod)) {
                return;
            }
            m22 = m4;
            if (Modifier.isFinal(mod)) {
                m22.setModifiers(mod &= 0xFFFFFFEF);
            }
        } else {
            if (Modifier.isFinal(mod)) {
                return;
            }
            m22 = CtNewMethod.delegator(this.findOriginal(m4, dontSearch), clazz);
            m22.setModifiers(mod &= 0xFFFFFEFF);
            clazz.addMethod(m22);
        }
        m22.setName("_m_" + identifier + "_" + name);
        CtMethod body = Modifier.isStatic(mod) ? this.trapStaticMethod : this.trapMethod;
        CtMethod wmethod = CtNewMethod.wrapped(m4.getReturnType(), name, m4.getParameterTypes(), m4.getExceptionTypes(), body, CtMethod.ConstParameter.integer(identifier), clazz);
        wmethod.setModifiers(mod);
        clazz.addMethod(wmethod);
    }

    private CtMethod findOriginal(CtMethod m4, boolean dontSearch) throws NotFoundException {
        if (dontSearch) {
            return m4;
        }
        String name = m4.getName();
        CtMethod[] ms = m4.getDeclaringClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            String orgName = ms[i].getName();
            if (!orgName.endsWith(name) || !orgName.startsWith("_m_") || !ms[i].getSignature().equals(m4.getSignature())) continue;
            return ms[i];
        }
        return m4;
    }

    private void processFields(CtClass clazz) throws CannotCompileException, NotFoundException {
        CtField[] fs = clazz.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            CtField f = fs[i];
            int mod = f.getModifiers();
            if ((mod & 1) == 0 || (mod & 0x10) != 0) continue;
            String name = f.getName();
            CtClass ftype = f.getType();
            CtMethod wmethod = CtNewMethod.wrapped(ftype, readPrefix + name, this.readParam, null, this.trapRead, CtMethod.ConstParameter.string(name), clazz);
            wmethod.setModifiers(mod |= 8);
            clazz.addMethod(wmethod);
            CtClass[] writeParam = new CtClass[]{this.classPool.get("java.lang.Object"), ftype};
            wmethod = CtNewMethod.wrapped(CtClass.voidType, writePrefix + name, writeParam, null, this.trapWrite, CtMethod.ConstParameter.string(name), clazz);
            wmethod.setModifiers(mod);
            clazz.addMethod(wmethod);
        }
    }

    public void rebuildClassFile(ClassFile cf) throws BadBytecode {
        if (ClassFile.MAJOR_VERSION < 50) {
            return;
        }
        for (MethodInfo mi : cf.getMethods()) {
            mi.rebuildStackMap(this.classPool);
        }
    }
}

