/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.netty.util.internal;

import com.iterable.shade.io.netty.util.internal.ObjectUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public final class BoundedInputStream
extends FilterInputStream {
    private final int maxBytesRead;
    private int numRead;

    public BoundedInputStream(@NotNull InputStream in, int maxBytesRead) {
        super(in);
        this.maxBytesRead = ObjectUtil.checkPositive(maxBytesRead, "maxRead");
    }

    public BoundedInputStream(@NotNull InputStream in) {
        this(in, 8192);
    }

    @Override
    public int read() throws IOException {
        this.checkMaxBytesRead(1);
        try {
            int b = super.read();
            if (b <= 0) {
                --this.numRead;
            }
            return b;
        }
        catch (IOException e) {
            --this.numRead;
            throw e;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int num = Math.min(len, this.maxBytesRead - this.numRead + 1);
        this.checkMaxBytesRead(num);
        try {
            int b = super.read(buf, off, num);
            if (b == -1) {
                this.numRead -= num;
            } else if (b != num) {
                this.numRead -= num - b;
            }
            return b;
        }
        catch (IOException e) {
            this.numRead -= num;
            throw e;
        }
    }

    private void checkMaxBytesRead(int n) throws IOException {
        int sum = this.numRead + n;
        if (sum < 0 || sum > this.maxBytesRead) {
            this.numRead = this.maxBytesRead + 1;
            throw new IOException("Maximum number of bytes read: " + this.maxBytesRead);
        }
        this.numRead = sum;
    }
}

