/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.netty.resolver.dns;

import com.iterable.shade.io.netty.bootstrap.Bootstrap;
import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.buffer.Unpooled;
import com.iterable.shade.io.netty.channel.AddressedEnvelope;
import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.channel.ChannelFactory;
import com.iterable.shade.io.netty.channel.ChannelFuture;
import com.iterable.shade.io.netty.channel.ChannelFutureListener;
import com.iterable.shade.io.netty.channel.ChannelHandler;
import com.iterable.shade.io.netty.channel.ChannelHandlerAdapter;
import com.iterable.shade.io.netty.channel.ChannelHandlerContext;
import com.iterable.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.iterable.shade.io.netty.channel.ChannelInitializer;
import com.iterable.shade.io.netty.channel.ChannelOption;
import com.iterable.shade.io.netty.channel.EventLoop;
import com.iterable.shade.io.netty.channel.FixedRecvByteBufAllocator;
import com.iterable.shade.io.netty.channel.socket.DatagramChannel;
import com.iterable.shade.io.netty.channel.socket.DatagramPacket;
import com.iterable.shade.io.netty.channel.socket.InternetProtocolFamily;
import com.iterable.shade.io.netty.channel.socket.SocketChannel;
import com.iterable.shade.io.netty.handler.codec.CorruptedFrameException;
import com.iterable.shade.io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import com.iterable.shade.io.netty.handler.codec.dns.DatagramDnsResponse;
import com.iterable.shade.io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import com.iterable.shade.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import com.iterable.shade.io.netty.handler.codec.dns.DnsQuestion;
import com.iterable.shade.io.netty.handler.codec.dns.DnsRawRecord;
import com.iterable.shade.io.netty.handler.codec.dns.DnsRecord;
import com.iterable.shade.io.netty.handler.codec.dns.DnsRecordType;
import com.iterable.shade.io.netty.handler.codec.dns.DnsResponse;
import com.iterable.shade.io.netty.resolver.DefaultHostsFileEntriesResolver;
import com.iterable.shade.io.netty.resolver.HostsFileEntriesResolver;
import com.iterable.shade.io.netty.resolver.InetNameResolver;
import com.iterable.shade.io.netty.resolver.ResolvedAddressTypes;
import com.iterable.shade.io.netty.resolver.dns.AuthoritativeDnsServerCache;
import com.iterable.shade.io.netty.resolver.dns.AuthoritativeDnsServerCacheAdapter;
import com.iterable.shade.io.netty.resolver.dns.BiDnsQueryLifecycleObserverFactory;
import com.iterable.shade.io.netty.resolver.dns.DatagramDnsQueryContext;
import com.iterable.shade.io.netty.resolver.dns.DnsAddressResolveContext;
import com.iterable.shade.io.netty.resolver.dns.DnsCache;
import com.iterable.shade.io.netty.resolver.dns.DnsCacheEntry;
import com.iterable.shade.io.netty.resolver.dns.DnsCnameCache;
import com.iterable.shade.io.netty.resolver.dns.DnsNameResolverChannelStrategy;
import com.iterable.shade.io.netty.resolver.dns.DnsNameResolverException;
import com.iterable.shade.io.netty.resolver.dns.DnsNameResolverTimeoutException;
import com.iterable.shade.io.netty.resolver.dns.DnsQueryContext;
import com.iterable.shade.io.netty.resolver.dns.DnsQueryContextManager;
import com.iterable.shade.io.netty.resolver.dns.DnsQueryLifecycleObserver;
import com.iterable.shade.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import com.iterable.shade.io.netty.resolver.dns.DnsRecordResolveContext;
import com.iterable.shade.io.netty.resolver.dns.DnsServerAddressStream;
import com.iterable.shade.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import com.iterable.shade.io.netty.resolver.dns.LoggingDnsQueryLifeCycleObserverFactory;
import com.iterable.shade.io.netty.resolver.dns.NameServerComparator;
import com.iterable.shade.io.netty.resolver.dns.NoopDnsCnameCache;
import com.iterable.shade.io.netty.resolver.dns.NoopDnsQueryLifecycleObserver;
import com.iterable.shade.io.netty.resolver.dns.NoopDnsQueryLifecycleObserverFactory;
import com.iterable.shade.io.netty.resolver.dns.SequentialDnsServerAddressStream;
import com.iterable.shade.io.netty.resolver.dns.ThreadLocalNameServerAddressStream;
import com.iterable.shade.io.netty.resolver.dns.UnixResolverDnsServerAddressStreamProvider;
import com.iterable.shade.io.netty.resolver.dns.UnixResolverOptions;
import com.iterable.shade.io.netty.util.AttributeKey;
import com.iterable.shade.io.netty.util.NetUtil;
import com.iterable.shade.io.netty.util.ReferenceCountUtil;
import com.iterable.shade.io.netty.util.concurrent.Future;
import com.iterable.shade.io.netty.util.concurrent.FutureListener;
import com.iterable.shade.io.netty.util.concurrent.GenericFutureListener;
import com.iterable.shade.io.netty.util.concurrent.Promise;
import com.iterable.shade.io.netty.util.concurrent.PromiseNotifier;
import com.iterable.shade.io.netty.util.internal.EmptyArrays;
import com.iterable.shade.io.netty.util.internal.ObjectUtil;
import com.iterable.shade.io.netty.util.internal.PlatformDependent;
import com.iterable.shade.io.netty.util.internal.StringUtil;
import com.iterable.shade.io.netty.util.internal.logging.InternalLogger;
import com.iterable.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DnsNameResolver
extends InetNameResolver {
    public static final AttributeKey<Boolean> DNS_PIPELINE_ATTRIBUTE;
    private static final InternalLogger logger;
    private static final String LOCALHOST = "localhost";
    private static final String WINDOWS_HOST_NAME;
    private static final InetAddress LOCALHOST_ADDRESS;
    private static final DnsRecord[] EMPTY_ADDITIONALS;
    private static final DnsRecordType[] IPV4_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_ONLY_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
    private static final DnsRecordType[] IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
    private static final InternetProtocolFamily[] IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
    private static final ChannelHandler NOOP_HANDLER;
    static final ResolvedAddressTypes DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEARCH_DOMAINS;
    private static final UnixResolverOptions DEFAULT_OPTIONS;
    private static final DatagramDnsResponseDecoder DATAGRAM_DECODER;
    private static final DatagramDnsQueryEncoder DATAGRAM_ENCODER;
    private final Comparator<InetSocketAddress> nameServerComparator;
    private final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final AuthoritativeDnsServerCache authoritativeDnsServerCache;
    private final DnsCnameCache cnameCache;
    private final DnsServerAddressStream queryDnsServerAddressStream;
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final ResolvedAddressTypes resolvedAddressTypes;
    private final InternetProtocolFamily[] resolvedInternetProtocolFamilies;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final DnsServerAddressStreamProvider dnsServerAddressStreamProvider;
    private final String[] searchDomains;
    private final int ndots;
    private final boolean supportsAAAARecords;
    private final boolean supportsARecords;
    private final InternetProtocolFamily preferredAddressType;
    private final DnsRecordType[] resolveRecordTypes;
    private final boolean decodeIdn;
    private final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;
    private final boolean completeOncePreferredResolved;
    private final DnsResolveChannelProvider resolveChannelProvider;
    private final Bootstrap socketBootstrap;
    private final boolean retryWithTcpOnTimeout;
    private final int maxNumConsolidation;
    private final Map<String, Future<List<InetAddress>>> inflightLookups;

    private static boolean anyInterfaceSupportsIpV6() {
        for (NetworkInterface iface : NetUtil.NETWORK_INTERFACES) {
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                if (!(inetAddress instanceof Inet6Address) || inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getSearchDomainsHack() throws Exception {
        if (PlatformDependent.javaVersion() < 9) {
            Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = configClass.getMethod("open", new Class[0]);
            Method nameservers = configClass.getMethod("searchlist", new Class[0]);
            Object instance = open.invoke(null, new Object[0]);
            return (List)nameservers.invoke(instance, new Object[0]);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, DnsCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, resolveCache, new AuthoritativeDnsServerCacheAdapter(authoritativeDnsServerCache), dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, traceEnabled, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, searchDomains, ndots, decodeIdn);
    }

    @Deprecated
    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsCache resolveCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, String[] searchDomains, int ndots, boolean decodeIdn) {
        this(eventLoop, channelFactory, null, false, resolveCache, NoopDnsCnameCache.INSTANCE, authoritativeDnsServerCache, null, dnsQueryLifecycleObserverFactory, queryTimeoutMillis, resolvedAddressTypes, recursionDesired, maxQueriesPerResolve, traceEnabled, maxPayloadSize, optResourceEnabled, hostsFileEntriesResolver, dnsServerAddressStreamProvider, new ThreadLocalNameServerAddressStream(dnsServerAddressStreamProvider), searchDomains, ndots, decodeIdn, false, 0, DnsNameResolverChannelStrategy.ChannelPerResolver);
    }

    DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, ChannelFactory<? extends SocketChannel> socketChannelFactory, boolean retryWithTcpOnTimeout, DnsCache resolveCache, DnsCnameCache cnameCache, AuthoritativeDnsServerCache authoritativeDnsServerCache, SocketAddress localAddress, DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory, long queryTimeoutMillis, ResolvedAddressTypes resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, final int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, DnsServerAddressStreamProvider dnsServerAddressStreamProvider, DnsServerAddressStream queryDnsServerAddressStream, String[] searchDomains, int ndots, boolean decodeIdn, boolean completeOncePreferredResolved, int maxNumConsolidation, DnsNameResolverChannelStrategy datagramChannelStrategy) {
        super(eventLoop);
        this.queryTimeoutMillis = queryTimeoutMillis >= 0L ? queryTimeoutMillis : TimeUnit.SECONDS.toMillis(DEFAULT_OPTIONS.timeout());
        this.resolvedAddressTypes = resolvedAddressTypes != null ? resolvedAddressTypes : DEFAULT_RESOLVE_ADDRESS_TYPES;
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = maxQueriesPerResolve > 0 ? maxQueriesPerResolve : DEFAULT_OPTIONS.attempts();
        this.maxPayloadSize = ObjectUtil.checkPositive(maxPayloadSize, "maxPayloadSize");
        this.optResourceEnabled = optResourceEnabled;
        this.hostsFileEntriesResolver = ObjectUtil.checkNotNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.dnsServerAddressStreamProvider = ObjectUtil.checkNotNull(dnsServerAddressStreamProvider, "dnsServerAddressStreamProvider");
        this.queryDnsServerAddressStream = ObjectUtil.checkNotNull(queryDnsServerAddressStream, "queryDnsServerAddressStream");
        this.resolveCache = ObjectUtil.checkNotNull(resolveCache, "resolveCache");
        this.cnameCache = ObjectUtil.checkNotNull(cnameCache, "cnameCache");
        this.dnsQueryLifecycleObserverFactory = traceEnabled ? (dnsQueryLifecycleObserverFactory instanceof NoopDnsQueryLifecycleObserverFactory ? new LoggingDnsQueryLifeCycleObserverFactory() : new BiDnsQueryLifecycleObserverFactory(new LoggingDnsQueryLifeCycleObserverFactory(), dnsQueryLifecycleObserverFactory)) : ObjectUtil.checkNotNull(dnsQueryLifecycleObserverFactory, "dnsQueryLifecycleObserverFactory");
        this.searchDomains = searchDomains != null ? (String[])searchDomains.clone() : DEFAULT_SEARCH_DOMAINS;
        this.ndots = ndots >= 0 ? ndots : DEFAULT_OPTIONS.ndots();
        this.decodeIdn = decodeIdn;
        this.completeOncePreferredResolved = completeOncePreferredResolved;
        this.retryWithTcpOnTimeout = retryWithTcpOnTimeout;
        if (socketChannelFactory == null) {
            this.socketBootstrap = null;
        } else {
            this.socketBootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.socketBootstrap.option(ChannelOption.SO_REUSEADDR, true)).group(this.executor())).channelFactory(socketChannelFactory)).attr(DNS_PIPELINE_ATTRIBUTE, Boolean.TRUE)).handler(NOOP_HANDLER);
            if (queryTimeoutMillis > 0L && queryTimeoutMillis <= Integer.MAX_VALUE) {
                this.socketBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)queryTimeoutMillis);
            }
        }
        switch (this.resolvedAddressTypes) {
            case IPV4_ONLY: {
                this.supportsAAAARecords = false;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV4_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV4_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_ONLY: {
                this.supportsAAAARecords = true;
                this.supportsARecords = false;
                this.resolveRecordTypes = IPV6_ONLY_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            case IPV6_PREFERRED: {
                this.supportsAAAARecords = true;
                this.supportsARecords = true;
                this.resolveRecordTypes = IPV6_PREFERRED_RESOLVED_RECORD_TYPES;
                this.resolvedInternetProtocolFamilies = IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
            }
        }
        this.preferredAddressType = DnsNameResolver.preferredAddressType(this.resolvedAddressTypes);
        this.authoritativeDnsServerCache = ObjectUtil.checkNotNull(authoritativeDnsServerCache, "authoritativeDnsServerCache");
        this.nameServerComparator = new NameServerComparator(this.preferredAddressType.addressType());
        this.maxNumConsolidation = maxNumConsolidation;
        this.inflightLookups = maxNumConsolidation > 0 ? new HashMap<String, Future<List<InetAddress>>>() : null;
        final DnsResponseHandler responseHandler = new DnsResponseHandler(this.queryContextManager);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(channelFactory)).group(eventLoop)).attr(DNS_PIPELINE_ATTRIBUTE, Boolean.TRUE)).handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) {
                ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
                ch.pipeline().addLast(DATAGRAM_ENCODER, DATAGRAM_DECODER, responseHandler);
            }
        });
        if (localAddress == null) {
            bootstrap.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        }
        this.resolveChannelProvider = DnsNameResolver.newProvider(datagramChannelStrategy, bootstrap, localAddress);
    }

    private static DnsResolveChannelProvider newProvider(DnsNameResolverChannelStrategy channelStrategy, Bootstrap bootstrap, SocketAddress localAddress) {
        switch (channelStrategy) {
            case ChannelPerResolver: {
                return new DnsResolveChannelPerResolverProvider(bootstrap, localAddress);
            }
            case ChannelPerResolution: {
                return new DnsResolveChannelPerResolutionProvider(bootstrap, localAddress);
            }
        }
        throw new IllegalArgumentException("Unknown DnsNameResolverChannelStrategy: " + (Object)((Object)channelStrategy));
    }

    static InternetProtocolFamily preferredAddressType(ResolvedAddressTypes resolvedAddressTypes) {
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: 
            case IPV4_PREFERRED: {
                return InternetProtocolFamily.IPv4;
            }
            case IPV6_ONLY: 
            case IPV6_PREFERRED: {
                return InternetProtocolFamily.IPv6;
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    InetSocketAddress newRedirectServerAddress(InetAddress server) {
        return new InetSocketAddress(server, 53);
    }

    final DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory() {
        return this.dnsQueryLifecycleObserverFactory;
    }

    protected DnsServerAddressStream newRedirectDnsServerStream(String hostname, List<InetSocketAddress> nameservers) {
        DnsServerAddressStream cached = this.authoritativeDnsServerCache().get(hostname);
        if (cached == null || cached.size() == 0) {
            Collections.sort(nameservers, this.nameServerComparator);
            return new SequentialDnsServerAddressStream(nameservers, 0);
        }
        return cached;
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public DnsCnameCache cnameCache() {
        return this.cnameCache;
    }

    public AuthoritativeDnsServerCache authoritativeDnsServerCache() {
        return this.authoritativeDnsServerCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public DnsServerAddressStream queryDnsServerAddressStream() {
        return this.queryDnsServerAddressStream;
    }

    public ResolvedAddressTypes resolvedAddressTypes() {
        return this.resolvedAddressTypes;
    }

    InternetProtocolFamily[] resolvedInternetProtocolFamiliesUnsafe() {
        return this.resolvedInternetProtocolFamilies;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    final boolean supportsAAAARecords() {
        return this.supportsAAAARecords;
    }

    final boolean supportsARecords() {
        return this.supportsARecords;
    }

    final InternetProtocolFamily preferredAddressType() {
        return this.preferredAddressType;
    }

    final DnsRecordType[] resolveRecordTypes() {
        return this.resolveRecordTypes;
    }

    final boolean isDecodeIdn() {
        return this.decodeIdn;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    @Override
    public void close() {
        this.resolveChannelProvider.close();
        this.resolveCache.clear();
        this.cnameCache.clear();
        this.authoritativeDnsServerCache.clear();
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes);
        return address == null && DnsNameResolver.isLocalWindowsHost(hostname) ? LOCALHOST_ADDRESS : address;
    }

    private List<InetAddress> resolveHostsFileEntries(String hostname) {
        InetAddress address;
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        List<InetAddress> addresses = this.hostsFileEntriesResolver instanceof DefaultHostsFileEntriesResolver ? ((DefaultHostsFileEntriesResolver)this.hostsFileEntriesResolver).addresses(hostname, this.resolvedAddressTypes) : ((address = this.hostsFileEntriesResolver.address(hostname, this.resolvedAddressTypes)) != null ? Collections.singletonList(address) : null);
        return addresses == null && DnsNameResolver.isLocalWindowsHost(hostname) ? Collections.singletonList(LOCALHOST_ADDRESS) : addresses;
    }

    private static boolean isLocalWindowsHost(String hostname) {
        return PlatformDependent.isWindows() && (LOCALHOST.equalsIgnoreCase(hostname) || WINDOWS_HOST_NAME != null && WINDOWS_HOST_NAME.equalsIgnoreCase(hostname));
    }

    @Override
    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolve(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals, Promise<InetAddress> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolve(inetHost, additionalsArray, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure(e);
        }
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolveAll(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals, Promise<List<InetAddress>> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolveAll(inetHost, additionalsArray, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure(e);
        }
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.doResolve(inetHost, EMPTY_ADDITIONALS, promise, this.resolveCache);
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question) {
        return this.resolveAll(question, EMPTY_ADDITIONALS, this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.resolveAll(question, additionals, this.executor().newPromise());
    }

    public final Future<List<DnsRecord>> resolveAll(DnsQuestion question, Iterable<DnsRecord> additionals, Promise<List<DnsRecord>> promise) {
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        return this.resolveAll(question, additionalsArray, promise);
    }

    private Future<List<DnsRecord>> resolveAll(final DnsQuestion question, final DnsRecord[] additionals, final Promise<List<DnsRecord>> promise) {
        ChannelFuture f;
        List<InetAddress> hostsFileEntries;
        ObjectUtil.checkNotNull(question, "question");
        ObjectUtil.checkNotNull(promise, "promise");
        DnsRecordType type = question.type();
        final String hostname = question.name();
        if ((type == DnsRecordType.A || type == DnsRecordType.AAAA) && (hostsFileEntries = this.resolveHostsFileEntries(hostname)) != null) {
            ArrayList<DefaultDnsRawRecord> result = new ArrayList<DefaultDnsRawRecord>();
            for (InetAddress inetAddress : hostsFileEntries) {
                ByteBuf content = null;
                if (inetAddress instanceof Inet4Address) {
                    if (type == DnsRecordType.A) {
                        content = Unpooled.wrappedBuffer(inetAddress.getAddress());
                    }
                } else if (inetAddress instanceof Inet6Address && type == DnsRecordType.AAAA) {
                    content = Unpooled.wrappedBuffer(inetAddress.getAddress());
                }
                if (content == null) continue;
                result.add(new DefaultDnsRawRecord(hostname, type, 86400L, content));
            }
            if (!result.isEmpty()) {
                if (!DnsNameResolver.trySuccess(promise, result)) {
                    for (DnsRecord dnsRecord : result) {
                        ReferenceCountUtil.safeRelease(dnsRecord);
                    }
                }
                return promise;
            }
        }
        if ((f = this.resolveChannelProvider.nextResolveChannel(promise)).isDone()) {
            this.resolveAllNow(f, hostname, question, additionals, promise);
        } else {
            f.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture f) {
                    DnsNameResolver.this.resolveAllNow(f, hostname, question, additionals, promise);
                }
            });
        }
        return promise;
    }

    private void resolveAllNow(ChannelFuture f, String hostname, DnsQuestion question, DnsRecord[] additionals, Promise<List<DnsRecord>> promise) {
        if (f.isSuccess()) {
            DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
            new DnsRecordResolveContext(this, f.channel(), promise, question, additionals, nameServerAddrs, this.maxQueriesPerResolve).resolve(promise);
        } else {
            UnknownHostException e = DnsNameResolver.toException(f, hostname, question, additionals);
            promise.setFailure(e);
        }
    }

    private static UnknownHostException toException(ChannelFuture f, String hostname, DnsQuestion question, DnsRecord[] additionals) {
        UnknownHostException e = new UnknownHostException("Failed to resolve '" + hostname + "', couldn't setup transport: " + f.channel());
        e.initCause(f.cause());
        if (question != null) {
            ReferenceCountUtil.release(question);
        }
        for (DnsRecord record : additionals) {
            ReferenceCountUtil.release(record);
        }
        return e;
    }

    private static DnsRecord[] toArray(Iterable<DnsRecord> additionals, boolean validateType) {
        ObjectUtil.checkNotNull(additionals, "additionals");
        if (additionals instanceof Collection) {
            Collection records = (Collection)additionals;
            for (DnsRecord r : additionals) {
                DnsNameResolver.validateAdditional(r, validateType);
            }
            return records.toArray(new DnsRecord[records.size()]);
        }
        Iterator<DnsRecord> additionalsIt = additionals.iterator();
        if (!additionalsIt.hasNext()) {
            return EMPTY_ADDITIONALS;
        }
        ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
        do {
            DnsRecord r = additionalsIt.next();
            DnsNameResolver.validateAdditional(r, validateType);
            records.add(r);
        } while (additionalsIt.hasNext());
        return records.toArray(new DnsRecord[records.size()]);
    }

    private static void validateAdditional(DnsRecord record, boolean validateType) {
        ObjectUtil.checkNotNull(record, "record");
        if (validateType && record instanceof DnsRawRecord) {
            throw new IllegalArgumentException("DnsRawRecord implementations not allowed: " + record);
        }
    }

    private InetAddress loopbackAddress() {
        return this.preferredAddressType().localhost();
    }

    protected void doResolve(String inetHost, final DnsRecord[] additionals, final Promise<InetAddress> promise, final DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess(this.loopbackAddress());
            return;
        }
        InetAddress address = NetUtil.createInetAddressFromIpAddressString(inetHost);
        if (address != null) {
            promise.setSuccess(address);
            return;
        }
        final String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, additionals, promise, resolveCache)) {
            ChannelFuture f = this.resolveChannelProvider.nextResolveChannel(promise);
            if (f.isDone()) {
                this.doResolveNow(f, hostname, additionals, promise, resolveCache);
            } else {
                f.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) {
                        DnsNameResolver.this.doResolveNow(f, hostname, additionals, promise, resolveCache);
                    }
                });
            }
        }
    }

    private void doResolveNow(ChannelFuture f, String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        if (f.isSuccess()) {
            this.doResolveUncached(f.channel(), hostname, additionals, promise, resolveCache, this.completeOncePreferredResolved);
        } else {
            UnknownHostException e = DnsNameResolver.toException(f, hostname, null, additionals);
            promise.setFailure(e);
        }
    }

    private boolean doResolveCached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            int numEntries = cachedEntries.size();
            for (InternetProtocolFamily f : this.resolvedInternetProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e = cachedEntries.get(i);
                    if (!f.addressType().isInstance(e.address())) continue;
                    DnsNameResolver.trySuccess(promise, e.address());
                    return true;
                }
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise, cause);
        return true;
    }

    static <T> boolean trySuccess(Promise<T> promise, T result) {
        boolean notifiedRecords = promise.trySuccess(result);
        if (!notifiedRecords) {
            logger.trace("Failed to notify success ({}) to a promise: {}", (Object)result, (Object)promise);
        }
        return notifiedRecords;
    }

    private static void tryFailure(Promise<?> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.trace("Failed to notify failure to a promise: {}", (Object)promise, (Object)cause);
        }
    }

    private void doResolveUncached(Channel channel, String hostname, DnsRecord[] additionals, final Promise<InetAddress> promise, DnsCache resolveCache, boolean completeEarlyIfPossible) {
        Promise<List<InetAddress>> allPromise = this.executor().newPromise();
        this.doResolveAllUncached(channel, hostname, additionals, promise, allPromise, resolveCache, completeEarlyIfPossible);
        allPromise.addListener((GenericFutureListener<Future<List<InetAddress>>>)new FutureListener<List<InetAddress>>(){

            @Override
            public void operationComplete(Future<List<InetAddress>> future) {
                if (future.isSuccess()) {
                    DnsNameResolver.trySuccess(promise, future.getNow().get(0));
                } else {
                    DnsNameResolver.tryFailure(promise, future.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(inetHost, EMPTY_ADDITIONALS, promise, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, final DnsRecord[] additionals, final Promise<List<InetAddress>> promise, final DnsCache resolveCache) throws Exception {
        if (inetHost == null || inetHost.isEmpty()) {
            promise.setSuccess(Collections.singletonList(this.loopbackAddress()));
            return;
        }
        InetAddress address = NetUtil.createInetAddressFromIpAddressString(inetHost);
        if (address != null) {
            promise.setSuccess(Collections.singletonList(address));
            return;
        }
        final String hostname = DnsNameResolver.hostname(inetHost);
        List<InetAddress> hostsFileEntries = this.resolveHostsFileEntries(hostname);
        if (hostsFileEntries != null) {
            promise.setSuccess(hostsFileEntries);
            return;
        }
        if (!DnsNameResolver.doResolveAllCached(hostname, additionals, promise, resolveCache, this.searchDomains(), this.ndots(), this.resolvedInternetProtocolFamilies)) {
            ChannelFuture f = this.resolveChannelProvider.nextResolveChannel(promise);
            if (f.isDone()) {
                this.doResolveAllNow(f, hostname, additionals, promise, resolveCache);
            } else {
                f.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) {
                        DnsNameResolver.this.doResolveAllNow(f, hostname, additionals, promise, resolveCache);
                    }
                });
            }
        }
    }

    private void doResolveAllNow(ChannelFuture f, String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        if (f.isSuccess()) {
            this.doResolveAllUncached(f.channel(), hostname, additionals, promise, promise, resolveCache, this.completeOncePreferredResolved);
        } else {
            UnknownHostException e = DnsNameResolver.toException(f, hostname, null, additionals);
            promise.setFailure(e);
        }
    }

    private static boolean hasEntries(List<? extends DnsCacheEntry> cachedEntries) {
        return cachedEntries != null && !cachedEntries.isEmpty();
    }

    static boolean doResolveAllCached(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache, String[] searchDomains, int ndots, InternetProtocolFamily[] resolvedInternetProtocolFamilies) {
        List<? extends DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (!DnsNameResolver.hasEntries(cachedEntries) && searchDomains != null && ndots != 0 && !StringUtil.endsWith(hostname, '.')) {
            for (String searchDomain : searchDomains) {
                String initialHostname = hostname + '.' + searchDomain;
                cachedEntries = resolveCache.get(initialHostname, additionals);
                if (DnsNameResolver.hasEntries(cachedEntries)) break;
            }
        }
        if (!DnsNameResolver.hasEntries(cachedEntries)) {
            return false;
        }
        Throwable cause = cachedEntries.get(0).cause();
        if (cause == null) {
            ArrayList<InetAddress> result = null;
            int numEntries = cachedEntries.size();
            for (InternetProtocolFamily f : resolvedInternetProtocolFamilies) {
                for (int i = 0; i < numEntries; ++i) {
                    DnsCacheEntry e = cachedEntries.get(i);
                    if (!f.addressType().isInstance(e.address())) continue;
                    if (result == null) {
                        result = new ArrayList<InetAddress>(numEntries);
                    }
                    result.add(e.address());
                }
            }
            if (result != null) {
                DnsNameResolver.trySuccess(promise, result);
                return true;
            }
            return false;
        }
        DnsNameResolver.tryFailure(promise, cause);
        return true;
    }

    private void doResolveAllUncached(final Channel channel, final String hostname, final DnsRecord[] additionals, final Promise<?> originalPromise, final Promise<List<InetAddress>> promise, final DnsCache resolveCache, final boolean completeEarlyIfPossible) {
        EventLoop executor = this.executor();
        if (executor.inEventLoop()) {
            this.doResolveAllUncached0(channel, hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DnsNameResolver.this.doResolveAllUncached0(channel, hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible);
                }
            });
        }
    }

    private void doResolveAllUncached0(final Channel channel, final String hostname, final DnsRecord[] additionals, final Promise<?> originalPromise, final Promise<List<InetAddress>> promise, final DnsCache resolveCache, final boolean completeEarlyIfPossible) {
        assert (this.executor().inEventLoop());
        if (this.inflightLookups != null && (additionals == null || additionals.length == 0)) {
            Future<List<InetAddress>> inflightFuture = this.inflightLookups.get(hostname);
            if (inflightFuture != null) {
                inflightFuture.addListener((GenericFutureListener<Future<List<InetAddress>>>)new GenericFutureListener<Future<? super List<InetAddress>>>(){

                    @Override
                    public void operationComplete(Future<? super List<InetAddress>> future) {
                        if (future.isSuccess()) {
                            promise.setSuccess(future.getNow());
                        } else {
                            Throwable cause = future.cause();
                            if (DnsNameResolver.isTimeoutError(cause)) {
                                DnsNameResolver.this.resolveNow(channel, hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible);
                            } else {
                                promise.setFailure(cause);
                            }
                        }
                    }
                });
                return;
            }
            if (this.inflightLookups.size() < this.maxNumConsolidation) {
                this.inflightLookups.put(hostname, promise);
                promise.addListener((GenericFutureListener<Future<List<InetAddress>>>)new GenericFutureListener<Future<? super List<InetAddress>>>(){

                    @Override
                    public void operationComplete(Future<? super List<InetAddress>> future) {
                        DnsNameResolver.this.inflightLookups.remove(hostname);
                    }
                });
            }
        }
        this.resolveNow(channel, hostname, additionals, originalPromise, promise, resolveCache, completeEarlyIfPossible);
    }

    private void resolveNow(Channel channel, String hostname, DnsRecord[] additionals, Promise<?> originalPromise, Promise<List<InetAddress>> promise, DnsCache resolveCache, boolean completeEarlyIfPossible) {
        DnsServerAddressStream nameServerAddrs = this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
        DnsAddressResolveContext ctx = new DnsAddressResolveContext(this, channel, originalPromise, hostname, additionals, nameServerAddrs, this.maxQueriesPerResolve, resolveCache, this.authoritativeDnsServerCache, completeEarlyIfPossible);
        ctx.resolve(promise);
    }

    private static String hostname(String inetHost) {
        String hostname = IDN.toASCII(inetHost);
        if (StringUtil.endsWith(inetHost, '.') && !StringUtil.endsWith(hostname, '.')) {
            hostname = hostname + ".";
        }
        return hostname;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query(this.nextNameServerAddress(), question, additionals);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, Collections.<DnsRecord>emptyList(), promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.queryDnsServerAddressStream.next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query(nameServerAddr, question, Collections.<DnsRecord>emptyList());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query(nameServerAddr, question, additionals, this.executor().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(nameServerAddr, question, Collections.<DnsRecord>emptyList(), promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(final InetSocketAddress nameServerAddr, final DnsQuestion question, Iterable<DnsRecord> additionals, final Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        ChannelFuture f = this.resolveChannelProvider.nextResolveChannel(promise);
        final DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, false);
        if (f.isDone()) {
            if (f.isSuccess()) {
                return this.doQuery(f.channel(), nameServerAddr, question, NoopDnsQueryLifecycleObserver.INSTANCE, additionalsArray, true, promise);
            }
            UnknownHostException e = DnsNameResolver.toException(f, question.name(), question, additionalsArray);
            promise.setFailure(e);
            return this.executor().newFailedFuture(e);
        }
        final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> p = this.executor().newPromise();
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture f) {
                if (f.isSuccess()) {
                    Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> qf = DnsNameResolver.this.doQuery(f.channel(), nameServerAddr, question, NoopDnsQueryLifecycleObserver.INSTANCE, additionalsArray, true, promise);
                    PromiseNotifier.cascade(qf, p);
                } else {
                    UnknownHostException e = DnsNameResolver.toException(f, question.name(), question, additionalsArray);
                    promise.setFailure(e);
                    p.setFailure(e);
                }
            }
        });
        return p;
    }

    public static boolean isTransportOrTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverException;
    }

    public static boolean isTimeoutError(Throwable cause) {
        return cause != null && cause.getCause() instanceof DnsNameResolverTimeoutException;
    }

    final Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> doQuery(Channel channel, InetSocketAddress nameServerAddr, DnsQuestion question, DnsQueryLifecycleObserver queryLifecycleObserver, DnsRecord[] additionals, boolean flush, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(ObjectUtil.checkNotNull(promise, "promise"));
        int payloadSize = this.isOptResourceEnabled() ? this.maxPayloadSize() : 0;
        try {
            DatagramDnsQueryContext queryContext = new DatagramDnsQueryContext(channel, nameServerAddr, this.queryContextManager, payloadSize, this.isRecursionDesired(), this.queryTimeoutMillis(), question, additionals, castPromise, this.socketBootstrap, this.retryWithTcpOnTimeout);
            ChannelFuture future = queryContext.writeQuery(flush);
            queryLifecycleObserver.queryWritten(nameServerAddr, future);
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure(e);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    final DnsServerAddressStream newNameServerAddressStream(String hostname) {
        return this.dnsServerAddressStreamProvider.nameServerAddressStream(hostname);
    }

    private static ChannelFuture registerOrBind(Bootstrap bootstrap, SocketAddress localAddress) {
        return localAddress == null ? bootstrap.register() : bootstrap.bind(localAddress);
    }

    static {
        UnixResolverOptions options;
        String[] searchDomains;
        String hostName;
        DNS_PIPELINE_ATTRIBUTE = AttributeKey.newInstance("com.iterable.shade.io.netty.resolver.dns.pipeline");
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        EMPTY_ADDITIONALS = new DnsRecord[0];
        IPV4_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A};
        IPV4_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4};
        IPV4_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.A, DnsRecordType.AAAA};
        IPV4_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4, InternetProtocolFamily.IPv6};
        IPV6_ONLY_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA};
        IPV6_ONLY_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6};
        IPV6_PREFERRED_RESOLVED_RECORD_TYPES = new DnsRecordType[]{DnsRecordType.AAAA, DnsRecordType.A};
        IPV6_PREFERRED_RESOLVED_PROTOCOL_FAMILIES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv6, InternetProtocolFamily.IPv4};
        NOOP_HANDLER = new ChannelHandlerAdapter(){

            @Override
            public boolean isSharable() {
                return true;
            }
        };
        if (NetUtil.isIpV4StackPreferred() || !DnsNameResolver.anyInterfaceSupportsIpV6()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_ONLY;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        } else if (NetUtil.isIpV6AddressesPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV6_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
        } else {
            DEFAULT_RESOLVE_ADDRESS_TYPES = ResolvedAddressTypes.IPV4_PREFERRED;
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        }
        logger.debug("Default ResolvedAddressTypes: {}", (Object)DEFAULT_RESOLVE_ADDRESS_TYPES);
        logger.debug("Localhost address: {}", (Object)LOCALHOST_ADDRESS);
        try {
            hostName = PlatformDependent.isWindows() ? InetAddress.getLocalHost().getHostName() : null;
        }
        catch (Exception ignore) {
            hostName = null;
        }
        WINDOWS_HOST_NAME = hostName;
        logger.debug("Windows hostname: {}", (Object)WINDOWS_HOST_NAME);
        try {
            List<String> list = PlatformDependent.isWindows() ? DnsNameResolver.getSearchDomainsHack() : UnixResolverDnsServerAddressStreamProvider.parseEtcResolverSearchDomains();
            searchDomains = list.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEARCH_DOMAINS = searchDomains;
        logger.debug("Default search domains: {}", (Object)Arrays.toString(DEFAULT_SEARCH_DOMAINS));
        try {
            options = UnixResolverDnsServerAddressStreamProvider.parseEtcResolverOptions();
        }
        catch (Exception ignore) {
            options = UnixResolverOptions.newBuilder().build();
        }
        DEFAULT_OPTIONS = options;
        logger.debug("Default {}", (Object)DEFAULT_OPTIONS);
        DATAGRAM_DECODER = new DatagramDnsResponseDecoder(){

            @Override
            protected DnsResponse decodeResponse(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
                DnsResponse response = super.decodeResponse(ctx, packet);
                if (((ByteBuf)packet.content()).isReadable()) {
                    response.setTruncated(true);
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} RECEIVED: UDP [{}: {}] truncated packet received, consider adjusting maxPayloadSize for the {}.", ctx.channel(), response.id(), packet.sender(), StringUtil.simpleClassName(DnsNameResolver.class));
                    }
                }
                return response;
            }
        };
        DATAGRAM_ENCODER = new DatagramDnsQueryEncoder();
    }

    private static final class DnsResolveChannelPerResolutionProvider
    implements DnsResolveChannelProvider {
        private final Bootstrap bootstrap;
        private final SocketAddress localAddress;

        DnsResolveChannelPerResolutionProvider(Bootstrap bootstrap, SocketAddress localAddress) {
            this.bootstrap = bootstrap;
            this.localAddress = localAddress;
        }

        @Override
        public <T> ChannelFuture nextResolveChannel(Future<T> resolutionFuture) {
            final ChannelFuture f = DnsNameResolver.registerOrBind(this.bootstrap, this.localAddress);
            resolutionFuture.addListener(new FutureListener<T>(){

                @Override
                public void operationComplete(Future<T> future) {
                    f.channel().close();
                }
            });
            return f;
        }

        @Override
        public void close() {
        }
    }

    private static final class DnsResolveChannelPerResolverProvider
    implements DnsResolveChannelProvider {
        private final ChannelFuture resolveChannelFuture;

        DnsResolveChannelPerResolverProvider(Bootstrap bootstrap, SocketAddress localAddress) {
            this.resolveChannelFuture = DnsNameResolver.registerOrBind(bootstrap, localAddress);
        }

        @Override
        public <T> ChannelFuture nextResolveChannel(Future<T> resolutionFuture) {
            return this.resolveChannelFuture;
        }

        @Override
        public void close() {
            this.resolveChannelFuture.channel().close();
        }
    }

    private static interface DnsResolveChannelProvider {
        public <T> ChannelFuture nextResolveChannel(Future<T> var1);

        public void close();
    }

    private static final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private final DnsQueryContextManager queryContextManager;

        DnsResponseHandler(DnsQueryContextManager queryContextManager) {
            this.queryContextManager = queryContextManager;
        }

        @Override
        public boolean isSharable() {
            return true;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Channel qCh = ctx.channel();
            DatagramDnsResponse res = (DatagramDnsResponse)msg;
            int queryId = res.id();
            logger.debug("{} RECEIVED: UDP [{}: {}], {}", qCh, queryId, res.sender(), res);
            DnsQueryContext qCtx = this.queryContextManager.get(res.sender(), queryId);
            if (qCtx == null) {
                logger.debug("{} Received a DNS response with an unknown ID: UDP [{}: {}]", qCh, queryId, res.sender());
                res.release();
                return;
            }
            if (qCtx.isDone()) {
                logger.debug("{} Received a DNS response for a query that was timed out or cancelled: UDP [{}: {}]", qCh, queryId, res.sender());
                res.release();
                return;
            }
            qCtx.finishSuccess(res, res.isTruncated());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof CorruptedFrameException) {
                logger.debug("{} Unable to decode DNS response: UDP", (Object)ctx.channel(), (Object)cause);
            } else {
                logger.warn("{} Unexpected exception: UDP", (Object)ctx.channel(), (Object)cause);
            }
        }
    }
}

