/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.netty.incubator.channel.uring;

import com.iterable.shade.io.netty.buffer.ByteBuf;
import com.iterable.shade.io.netty.channel.socket.DatagramPacket;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringDatagramChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringEventLoop;
import com.iterable.shade.io.netty.incubator.channel.uring.Iov;
import com.iterable.shade.io.netty.incubator.channel.uring.LinuxSocket;
import com.iterable.shade.io.netty.incubator.channel.uring.MsgHdr;
import com.iterable.shade.io.netty.incubator.channel.uring.Native;
import com.iterable.shade.io.netty.incubator.channel.uring.SockaddrIn;
import com.iterable.shade.io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;

final class MsgHdrMemory {
    private final long memory;
    private final int idx;
    private final long cmsgDataAddr;

    MsgHdrMemory(int idx) {
        this.idx = idx;
        int size = Native.SIZEOF_MSGHDR + Native.SIZEOF_SOCKADDR_STORAGE + Native.SIZEOF_IOVEC + Native.CMSG_SPACE;
        this.memory = PlatformDependent.allocateMemory(size);
        PlatformDependent.setMemory(this.memory, size, (byte)0);
        this.cmsgDataAddr = Native.cmsghdrData(this.memory + (long)Native.SIZEOF_MSGHDR + (long)Native.SIZEOF_SOCKADDR_STORAGE + (long)Native.SIZEOF_IOVEC);
    }

    void write(LinuxSocket socket, InetSocketAddress address, long bufferAddress, int length, short segmentSize) {
        int addressLength;
        long sockAddress = this.memory + (long)Native.SIZEOF_MSGHDR;
        long iovAddress = sockAddress + (long)Native.SIZEOF_SOCKADDR_STORAGE;
        long cmsgAddr = iovAddress + (long)Native.SIZEOF_IOVEC;
        if (address == null) {
            addressLength = socket.isIpv6() ? Native.SIZEOF_SOCKADDR_IN6 : Native.SIZEOF_SOCKADDR_IN;
            PlatformDependent.setMemory(sockAddress, Native.SIZEOF_SOCKADDR_STORAGE, (byte)0);
        } else {
            addressLength = SockaddrIn.write(socket.isIpv6(), sockAddress, address);
        }
        Iov.write(iovAddress, bufferAddress, length);
        MsgHdr.write(this.memory, sockAddress, addressLength, iovAddress, 1, cmsgAddr, this.cmsgDataAddr, segmentSize);
    }

    boolean hasPort(IOUringDatagramChannel channel) {
        long sockAddress = this.memory + (long)Native.SIZEOF_MSGHDR;
        if (channel.socket.isIpv6()) {
            return SockaddrIn.hasPortIpv6(sockAddress);
        }
        return SockaddrIn.hasPortIpv4(sockAddress);
    }

    DatagramPacket read(IOUringDatagramChannel channel, ByteBuf buffer, int bytesRead) {
        InetSocketAddress sender;
        long sockAddress = this.memory + (long)Native.SIZEOF_MSGHDR;
        IOUringEventLoop eventLoop = (IOUringEventLoop)channel.eventLoop();
        if (channel.socket.isIpv6()) {
            byte[] ipv6Bytes = eventLoop.inet6AddressArray();
            byte[] ipv4bytes = eventLoop.inet4AddressArray();
            sender = SockaddrIn.readIPv6(sockAddress, ipv6Bytes, ipv4bytes);
        } else {
            byte[] bytes = eventLoop.inet4AddressArray();
            sender = SockaddrIn.readIPv4(sockAddress, bytes);
        }
        long iovAddress = this.memory + (long)Native.SIZEOF_MSGHDR + (long)Native.SIZEOF_SOCKADDR_STORAGE;
        long bufferAddress = Iov.readBufferAddress(iovAddress);
        int bufferLength = Iov.readBufferLength(iovAddress);
        int readerIndex = (int)(bufferAddress - buffer.memoryAddress());
        ByteBuf slice = buffer.slice(readerIndex, bufferLength).writerIndex(bytesRead);
        return new DatagramPacket(slice.retain(), channel.localAddress(), sender);
    }

    int idx() {
        return this.idx;
    }

    long address() {
        return this.memory;
    }

    void release() {
        PlatformDependent.freeMemory(this.memory);
    }
}

