/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.netty.incubator.channel.uring;

import com.iterable.shade.io.netty.channel.Channel;
import com.iterable.shade.io.netty.channel.socket.ServerSocketChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.AbstractIOUringServerChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUring;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringEventLoop;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringServerSocketChannelConfig;
import com.iterable.shade.io.netty.incubator.channel.uring.IOUringSocketChannel;
import com.iterable.shade.io.netty.incubator.channel.uring.LinuxSocket;
import com.iterable.shade.io.netty.incubator.channel.uring.SockaddrIn;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class IOUringServerSocketChannel
extends AbstractIOUringServerChannel
implements ServerSocketChannel {
    private final IOUringServerSocketChannelConfig config = new IOUringServerSocketChannelConfig(this);

    public IOUringServerSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
    }

    @Override
    public IOUringServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    Channel newChildChannel(int fd, long acceptedAddressMemoryAddress, long acceptedAddressLengthMemoryAddress) {
        InetSocketAddress address;
        if (this.socket.isIpv6()) {
            byte[] ipv6Array = ((IOUringEventLoop)this.eventLoop()).inet6AddressArray();
            byte[] ipv4Array = ((IOUringEventLoop)this.eventLoop()).inet4AddressArray();
            address = SockaddrIn.readIPv6(acceptedAddressMemoryAddress, ipv6Array, ipv4Array);
        } else {
            byte[] addressArray = ((IOUringEventLoop)this.eventLoop()).inet4AddressArray();
            address = SockaddrIn.readIPv4(acceptedAddressMemoryAddress, addressArray);
        }
        return new IOUringSocketChannel((Channel)this, new LinuxSocket(fd), address);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public void doBind(SocketAddress localAddress) throws Exception {
        int fastOpen;
        super.doBind(localAddress);
        if (IOUring.isTcpFastOpenServerSideAvailable() && (fastOpen = this.config().getTcpFastopen()) > 0) {
            this.socket.setTcpFastOpen(fastOpen);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }
}

