/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions;

import com.iterable.shade.io.netty.channel.ChannelDuplexHandler;
import com.iterable.shade.io.netty.channel.ChannelHandlerContext;
import com.iterable.shade.io.netty.channel.ChannelPromise;
import com.iterable.shade.io.netty.handler.codec.CodecException;
import com.iterable.shade.io.netty.handler.codec.http.HttpHeaderNames;
import com.iterable.shade.io.netty.handler.codec.http.HttpRequest;
import com.iterable.shade.io.netty.handler.codec.http.HttpResponse;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import com.iterable.shade.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import com.iterable.shade.io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WebSocketClientExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketClientExtensionHandshaker> extensionHandshakers;

    public WebSocketClientExtensionHandler(WebSocketClientExtensionHandshaker ... extensionHandshakers) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty(extensionHandshakers, "extensionHandshakers"));
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade(((HttpRequest)msg).headers())) {
            HttpRequest request = (HttpRequest)msg;
            String headerValue = request.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
            for (WebSocketClientExtensionHandshaker extensionHandshaker : this.extensionHandshakers) {
                extraExtensions.add(extensionHandshaker.newRequestData());
            }
            String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
            request.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
        }
        super.write(ctx, msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpResponse response;
        if (msg instanceof HttpResponse && WebSocketExtensionUtil.isWebsocketUpgrade((response = (HttpResponse)msg).headers())) {
            String extensionsHeader = response.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader != null) {
                List<WebSocketExtensionData> extensions = WebSocketExtensionUtil.extractExtensions(extensionsHeader);
                ArrayList<WebSocketExtension> validExtensions = new ArrayList<WebSocketExtension>(extensions.size());
                int rsv = 0;
                for (WebSocketExtensionData webSocketExtensionData : extensions) {
                    Iterator<WebSocketClientExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                    WebSocketExtension validExtension = null;
                    while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                        WebSocketClientExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                        validExtension = extensionHandshaker.handshakeExtension(webSocketExtensionData);
                    }
                    if (validExtension != null && (validExtension.rsv() & rsv) == 0) {
                        rsv |= validExtension.rsv();
                        validExtensions.add(validExtension);
                        continue;
                    }
                    throw new CodecException("invalid WebSocket Extension handshake for \"" + extensionsHeader + '\"');
                }
                for (WebSocketClientExtension webSocketClientExtension : validExtensions) {
                    WebSocketExtensionDecoder decoder = webSocketClientExtension.newExtensionDecoder();
                    WebSocketExtensionEncoder encoder = webSocketClientExtension.newExtensionEncoder();
                    ctx.pipeline().addAfter(ctx.name(), decoder.getClass().getName(), decoder);
                    ctx.pipeline().addAfter(ctx.name(), encoder.getClass().getName(), encoder);
                }
            }
            ctx.pipeline().remove(ctx.name());
        }
        super.channelRead(ctx, msg);
    }
}

