/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.airlift.compress.lzo;

import com.iterable.shade.io.airlift.compress.hadoop.HadoopInputStream;
import com.iterable.shade.io.airlift.compress.hadoop.HadoopOutputStream;
import com.iterable.shade.io.airlift.compress.hadoop.HadoopStreams;
import com.iterable.shade.io.airlift.compress.lzo.LzopHadoopInputStream;
import com.iterable.shade.io.airlift.compress.lzo.LzopHadoopOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class LzopHadoopStreams
implements HadoopStreams {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final int bufferSize;

    public LzopHadoopStreams() {
        this(262144);
    }

    public LzopHadoopStreams(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".lzo";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("com.hadoop.compression.lzo.LzopCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new LzopHadoopInputStream(in, this.bufferSize);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new LzopHadoopOutputStream(out, this.bufferSize);
    }
}

