/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.io.airlift.compress.lzo;

import com.iterable.shade.io.airlift.compress.hadoop.HadoopInputStream;
import com.iterable.shade.io.airlift.compress.hadoop.HadoopOutputStream;
import com.iterable.shade.io.airlift.compress.hadoop.HadoopStreams;
import com.iterable.shade.io.airlift.compress.lzo.LzoHadoopInputStream;
import com.iterable.shade.io.airlift.compress.lzo.LzoHadoopOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LzoHadoopStreams
implements HadoopStreams {
    private static final List<String> HADOOP_CODEC_NAMES = Collections.unmodifiableList(Arrays.asList("org.apache.hadoop.io.compress.LzoCodec", "com.hadoop.compression.lzo.LzoCodec"));
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final int bufferSize;

    public LzoHadoopStreams() {
        this(262144);
    }

    public LzoHadoopStreams(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".lzo_deflate";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return HADOOP_CODEC_NAMES;
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) {
        return new LzoHadoopInputStream(in, this.bufferSize);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) {
        return new LzoHadoopOutputStream(out, this.bufferSize);
    }
}

