/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.tuple;

import com.iterable.shade.com.yahoo.sketches.SketchesStateException;
import com.iterable.shade.com.yahoo.sketches.tuple.CompactSketch;
import com.iterable.shade.com.yahoo.sketches.tuple.QuickSelectSketch;
import com.iterable.shade.com.yahoo.sketches.tuple.Sketch;
import com.iterable.shade.com.yahoo.sketches.tuple.SketchIterator;
import com.iterable.shade.com.yahoo.sketches.tuple.Summary;
import com.iterable.shade.com.yahoo.sketches.tuple.SummaryFactory;
import java.lang.reflect.Array;

public class Intersection<S extends Summary> {
    private final SummaryFactory<S> summaryFactory_;
    private QuickSelectSketch<S> sketch_;
    private boolean isEmpty_;
    private long theta_;
    private boolean isFirstCall_;

    public Intersection(SummaryFactory<S> summaryFactory) {
        this.summaryFactory_ = summaryFactory;
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.isFirstCall_ = true;
    }

    public void update(Sketch<S> sketchIn) {
        boolean isFirstCall = this.isFirstCall_;
        this.isFirstCall_ = false;
        if (sketchIn == null) {
            this.isEmpty_ = true;
            this.sketch_ = null;
            return;
        }
        this.theta_ = Math.min(this.theta_, sketchIn.getThetaLong());
        this.isEmpty_ |= sketchIn.isEmpty();
        if (this.isEmpty_ || sketchIn.getRetainedEntries() == 0) {
            this.sketch_ = null;
            return;
        }
        if (isFirstCall) {
            this.sketch_ = new QuickSelectSketch<S>(sketchIn.getRetainedEntries(), 0, this.summaryFactory_);
            SketchIterator<S> it = sketchIn.iterator();
            while (it.next()) {
                Object summary = it.getSummary().copy();
                this.sketch_.insert(it.getKey(), summary);
            }
        } else {
            int matchSize = Math.min(this.sketch_.getRetainedEntries(), sketchIn.getRetainedEntries());
            long[] matchKeys = new long[matchSize];
            Summary[] matchSummaries = (Summary[])Array.newInstance(this.summaryFactory_.newSummary().getClass(), matchSize);
            int matchCount = 0;
            SketchIterator<S> it = sketchIn.iterator();
            while (it.next()) {
                S summary = this.sketch_.find(it.getKey());
                if (summary == null) continue;
                matchKeys[matchCount] = it.getKey();
                matchSummaries[matchCount] = this.summaryFactory_.getSummarySetOperations().intersection(summary, it.getSummary());
                ++matchCount;
            }
            this.sketch_ = null;
            if (matchCount > 0) {
                this.sketch_ = new QuickSelectSketch<S>(matchCount, 0, this.summaryFactory_);
                for (int i = 0; i < matchCount; ++i) {
                    this.sketch_.insert(matchKeys[i], matchSummaries[i]);
                }
            }
        }
        if (this.sketch_ != null) {
            this.sketch_.setThetaLong(this.theta_);
            this.sketch_.setNotEmpty();
        }
    }

    public CompactSketch<S> getResult() {
        if (this.isFirstCall_) {
            throw new SketchesStateException("getResult() with no intervening intersections is not a legal result.");
        }
        if (this.sketch_ == null) {
            return new CompactSketch(null, null, this.theta_, this.isEmpty_);
        }
        return this.sketch_.compact();
    }

    public void reset() {
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.sketch_ = null;
        this.isFirstCall_ = true;
    }
}

