/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.tuple;

import com.iterable.shade.com.yahoo.memory.Memory;
import com.iterable.shade.com.yahoo.memory.NativeMemory;
import com.iterable.shade.com.yahoo.sketches.tuple.DeserializeResult;
import com.iterable.shade.com.yahoo.sketches.tuple.UpdatableSummary;

public final class DoubleSummary
implements UpdatableSummary<Double> {
    private double value_;
    private final Mode mode_;
    private static final int SERIALIZED_SIZE_BYTES = 9;
    private static final int VALUE_DOUBLE = 0;
    private static final int MODE_BYTE = 8;

    public DoubleSummary() {
        this(0.0, Mode.Sum);
    }

    public DoubleSummary(Mode mode) {
        this.mode_ = mode;
        switch (mode) {
            case Sum: {
                this.value_ = 0.0;
                break;
            }
            case Min: {
                this.value_ = Double.POSITIVE_INFINITY;
                break;
            }
            case Max: {
                this.value_ = Double.NEGATIVE_INFINITY;
            }
        }
    }

    public DoubleSummary(double value, Mode mode) {
        this.value_ = value;
        this.mode_ = mode;
    }

    @Override
    public void update(Double value) {
        switch (this.mode_) {
            case Sum: {
                this.value_ += value.doubleValue();
                break;
            }
            case Min: {
                if (!(value < this.value_)) break;
                this.value_ = value;
                break;
            }
            case Max: {
                if (!(value > this.value_)) break;
                this.value_ = value;
            }
        }
    }

    public DoubleSummary copy() {
        return new DoubleSummary(this.value_, this.mode_);
    }

    public double getValue() {
        return this.value_;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[9];
        NativeMemory mem = new NativeMemory(bytes);
        mem.putDouble(0L, this.value_);
        mem.putByte(8L, (byte)this.mode_.ordinal());
        return bytes;
    }

    public static DeserializeResult<DoubleSummary> fromMemory(Memory mem) {
        return new DeserializeResult<DoubleSummary>(new DoubleSummary(mem.getDouble(0L), Mode.values()[mem.getByte(8L)]), 9);
    }

    public static enum Mode {
        Sum,
        Min,
        Max;

    }
}

