/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.theta;

import com.iterable.shade.com.yahoo.memory.NativeMemory;
import com.iterable.shade.com.yahoo.sketches.ResizeFactor;
import com.iterable.shade.com.yahoo.sketches.Util;
import com.iterable.shade.com.yahoo.sketches.theta.UpdateSketch;

abstract class HeapUpdateSketch
extends UpdateSketch {
    final int lgNomLongs_;
    private final long seed_;
    private final float p_;
    private final ResizeFactor rf_;

    HeapUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.seed_ = seed;
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return this.rf_;
    }

    @Override
    int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    int getLgResizeFactor() {
        return this.rf_.lg();
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.getSeed());
    }

    byte[] toByteArray(int preLongs, byte family) {
        if (this.isDirty()) {
            this.rebuild();
        }
        int preBytes = preLongs << 3;
        int dataBytes = this.getCurrentDataLongs(false) << 3;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        NativeMemory memOut = new NativeMemory(byteArrOut);
        byte byte0 = (byte)(this.getLgResizeFactor() << 6 | preLongs);
        memOut.putByte(0L, byte0);
        memOut.putByte(1L, (byte)3);
        memOut.putByte(2L, family);
        memOut.putByte(3L, (byte)this.getLgNomLongs());
        memOut.putByte(4L, (byte)this.getLgArrLongs());
        memOut.putShort(6L, this.getSeedHash());
        memOut.putInt(8L, this.getRetainedEntries(true));
        memOut.putFloat(12L, this.getP());
        memOut.putLong(16L, this.getThetaLong());
        byte flags = this.isEmpty() ? (byte)4 : 0;
        memOut.putByte(5L, flags);
        int arrLongs = 1 << this.getLgArrLongs();
        long[] cache = this.getCache();
        memOut.putLongArray(preBytes, cache, 0, arrLongs);
        return byteArrOut;
    }
}

