/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.theta;

import com.iterable.shade.com.yahoo.memory.Memory;
import com.iterable.shade.com.yahoo.sketches.SketchesArgumentException;
import com.iterable.shade.com.yahoo.sketches.Util;
import com.iterable.shade.com.yahoo.sketches.theta.CompactSketch;
import com.iterable.shade.com.yahoo.sketches.theta.HeapCompactOrderedSketch;

final class ForwardCompatibility {
    ForwardCompatibility() {
    }

    static final CompactSketch heapify1to3(Memory srcMem, long seed) {
        int memCap = (int)srcMem.getCapacity();
        short seedHash = Util.computeSeedHash(seed);
        if (memCap <= 24) {
            return new HeapCompactOrderedSketch(new long[0], true, seedHash, 0, Long.MAX_VALUE);
        }
        int curCount = srcMem.getInt(8L);
        int mdLongs = 3;
        int reqBytesIn = curCount + 3 << 3;
        ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
        long thetaLong = srcMem.getLong(16L);
        long[] compactOrderedCache = new long[curCount];
        srcMem.getLongArray(24L, compactOrderedCache, 0, curCount);
        return new HeapCompactOrderedSketch(compactOrderedCache, false, seedHash, curCount, thetaLong);
    }

    static final CompactSketch heapify2to3(Memory srcMem, long seed) {
        int memCap = (int)srcMem.getCapacity();
        short seedHash = Util.computeSeedHash(seed);
        short memSeedHash = srcMem.getShort(6L);
        Util.checkSeedHashes(seedHash, memSeedHash);
        if (memCap == 8) {
            return new HeapCompactOrderedSketch(new long[0], true, seedHash, 0, Long.MAX_VALUE);
        }
        int curCount = srcMem.getInt(8L);
        int mdLongs = srcMem.getByte(0L) & 0x3F;
        int reqBytesIn = curCount + mdLongs << 3;
        ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
        long thetaLong = mdLongs < 3 ? Long.MAX_VALUE : srcMem.getLong(16L);
        boolean empty = srcMem.isAnyBitsSet(5L, (byte)4);
        long[] compactOrderedCache = new long[curCount];
        srcMem.getLongArray(mdLongs << 3, compactOrderedCache, 0, curCount);
        return new HeapCompactOrderedSketch(compactOrderedCache, empty, seedHash, curCount, thetaLong);
    }

    private static final void validateInputSize(int reqBytesIn, int memCap) {
        if (reqBytesIn > memCap) {
            throw new SketchesArgumentException("Input Memory or byte[] size is too small: Required Bytes: " + reqBytesIn + ", bytesIn: " + memCap);
        }
    }
}

