/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.theta;

import com.iterable.shade.com.yahoo.sketches.ResizeFactor;
import com.iterable.shade.com.yahoo.sketches.Util;
import com.iterable.shade.com.yahoo.sketches.theta.UpdateSketch;

abstract class DirectUpdateSketch
extends UpdateSketch {
    final int lgNomLongs_;
    private final long seed_;
    private final float p_;
    private final ResizeFactor rf_;

    DirectUpdateSketch(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        this.lgNomLongs_ = Math.max(lgNomLongs, 4);
        this.seed_ = seed;
        this.p_ = p;
        this.rf_ = rf;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public ResizeFactor getResizeFactor() {
        return this.rf_;
    }

    @Override
    int getLgNomLongs() {
        return this.lgNomLongs_;
    }

    @Override
    int getLgResizeFactor() {
        return this.rf_.lg();
    }

    @Override
    long getSeed() {
        return this.seed_;
    }

    @Override
    float getP() {
        return this.p_;
    }

    @Override
    short getSeedHash() {
        return Util.computeSeedHash(this.getSeed());
    }
}

