/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.quantiles;

import com.iterable.shade.com.yahoo.memory.Memory;
import com.iterable.shade.com.yahoo.sketches.ArrayOfItemsSerDe;
import com.iterable.shade.com.yahoo.sketches.quantiles.ItemsSketch;
import com.iterable.shade.com.yahoo.sketches.quantiles.ItemsUtil;
import java.util.Comparator;

public final class ItemsUnion<T> {
    protected final int k_;
    protected final Comparator<? super T> comparator_;
    protected ItemsSketch<T> gadget_;

    private ItemsUnion(int k, Comparator<? super T> comparator, ItemsSketch<T> gadget) {
        this.k_ = k;
        this.comparator_ = comparator;
        this.gadget_ = gadget;
    }

    public static <T> ItemsUnion<T> getInstance(Comparator<? super T> comparator) {
        return new ItemsUnion<T>(128, comparator, null);
    }

    public static <T> ItemsUnion<T> getInstance(int k, Comparator<? super T> comparator) {
        return new ItemsUnion<T>(k, comparator, null);
    }

    public static <T> ItemsUnion<T> getInstance(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        ItemsSketch<T> gadget = ItemsSketch.getInstance(srcMem, comparator, serDe);
        return new ItemsUnion<T>(gadget.getK(), gadget.getComparator(), gadget);
    }

    public static <T> ItemsUnion<T> getInstance(ItemsSketch<T> sketch) {
        return new ItemsUnion<T>(sketch.getK(), sketch.getComparator(), sketch);
    }

    static <T> ItemsSketch<T> updateLogic(int myK, Comparator<? super T> comparator, ItemsSketch<T> myQS, ItemsSketch<T> other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
            }
        }
        ItemsSketch<Object> ret = null;
        switch (outCase) {
            case 0: {
                ret = null;
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                if (myK < other.getK()) {
                    ret = other.downSample(myK);
                    break;
                }
                ret = ItemsSketch.copy(other);
                break;
            }
            case 3: {
                if (myQS.getK() <= other.getK()) {
                    ItemsUnion.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                ItemsSketch<T> myNewQS = ItemsSketch.copy(other);
                ItemsUnion.mergeInto(myQS, myNewQS);
                ret = myNewQS;
                break;
            }
            case 4: {
                ret = ItemsSketch.getInstance(Math.min(myK, other.getK()), comparator);
            }
        }
        return ret;
    }

    static <T> void mergeInto(ItemsSketch<T> source, ItemsSketch<T> target) {
        long srcBitPattern;
        Object[] srcLevels;
        int srcK = source.getK();
        int tgtK = target.getK();
        long srcN = source.getN();
        long tgtN = target.getN();
        if (srcK != tgtK) {
            ItemsUtil.downSamplingMergeInto(source, target);
            return;
        }
        Object[] srcBaseBuffer = srcLevels = source.getCombinedBuffer();
        long nFinal = tgtN + srcN;
        for (int i = 0; i < source.getBaseBufferCount(); ++i) {
            target.update(srcBaseBuffer[i]);
        }
        ItemsUtil.maybeGrowLevels(nFinal, target);
        Object[] scratchBuf = new Object[2 * tgtK];
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        int srcLvl = 0;
        for (srcBitPattern = source.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                ItemsUtil.inPlacePropagateCarry(srcLvl, srcLevels, (2 + srcLvl) * tgtK, scratchBuf, 0, false, target);
            }
            ++srcLvl;
        }
        target.n_ = nFinal;
        assert (target.getN() / (long)(2 * tgtK) == target.getBitPattern());
        T srcMax = source.getMaxValue();
        T srcMin = source.getMinValue();
        T tgtMax = target.getMaxValue();
        T tgtMin = target.getMinValue();
        if (source.getComparator().compare(srcMax, tgtMax) > 0) {
            target.maxValue_ = srcMax;
        }
        if (source.getComparator().compare(srcMin, tgtMin) < 0) {
            target.minValue_ = srcMin;
        }
    }

    public void update(ItemsSketch<T> sketchIn) {
        this.gadget_ = ItemsUnion.updateLogic(this.k_, this.comparator_, this.gadget_, sketchIn);
    }

    public void update(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        ItemsSketch<? super T> that = ItemsSketch.getInstance(srcMem, this.comparator_, serDe);
        this.gadget_ = ItemsUnion.updateLogic(this.k_, this.comparator_, this.gadget_, that);
    }

    public void update(T dataItem) {
        if (dataItem == null) {
            return;
        }
        if (this.gadget_ == null) {
            this.gadget_ = ItemsSketch.getInstance(this.k_, this.comparator_);
        }
        this.gadget_.update(dataItem);
    }

    public ItemsSketch<T> getResult() {
        if (this.gadget_ == null) {
            return ItemsSketch.getInstance(this.k_, this.comparator_);
        }
        return ItemsSketch.copy(this.gadget_);
    }

    public ItemsSketch<T> getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        ItemsSketch<T> hqs = this.gadget_;
        this.gadget_ = null;
        return hqs;
    }

    public void reset() {
        this.gadget_ = null;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        if (this.gadget_ == null) {
            return ItemsSketch.getInstance(this.k_, this.comparator_).toString();
        }
        return this.gadget_.toString(sketchSummary, dataDetail);
    }
}

