/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.hll;

import com.iterable.shade.com.yahoo.sketches.SketchesArgumentException;
import com.iterable.shade.com.yahoo.sketches.hll.CouponHashMap;
import com.iterable.shade.com.yahoo.sketches.hll.CouponTraverseMap;
import com.iterable.shade.com.yahoo.sketches.hll.CouponsIterator;
import com.iterable.shade.com.yahoo.sketches.hll.HllMap;
import com.iterable.shade.com.yahoo.sketches.hll.Map;
import com.iterable.shade.com.yahoo.sketches.hll.SingleCouponMap;

public class UniqueCountMap {
    private static final String LS = System.getProperty("line.separator");
    private static final int NUM_LEVELS = 10;
    private static final int NUM_TRAVERSE_MAPS = 3;
    private static final int HLL_K = 1024;
    private static final int INITIAL_NUM_ENTRIES = 1000003;
    private static final int MIN_INITIAL_NUM_ENTRIES = 157;
    private final int keySizeBytes_;
    private final Map[] maps_;

    public UniqueCountMap(int keySizeBytes) {
        this(1000003, keySizeBytes);
    }

    public UniqueCountMap(int initialNumEntries, int keySizeBytes) {
        UniqueCountMap.checkConstructorKeySize(keySizeBytes);
        int initEntries = Math.max(initialNumEntries, 157);
        this.keySizeBytes_ = keySizeBytes;
        this.maps_ = new Map[10];
        this.maps_[0] = SingleCouponMap.getInstance(initEntries, keySizeBytes);
    }

    public double update(byte[] key, byte[] identifier) {
        if (key == null) {
            return Double.NaN;
        }
        this.checkMethodKeySize(key);
        if (identifier == null) {
            return this.getEstimate(key);
        }
        short coupon = (short)Map.coupon16(identifier);
        int baseMapIndex = this.maps_[0].findOrInsertKey(key);
        double baseMapEstimate = this.maps_[0].update(baseMapIndex, coupon);
        if (baseMapEstimate > 0.0) {
            return baseMapEstimate;
        }
        int level = -((int)baseMapEstimate);
        if (level == 0) {
            return this.promote(key, coupon, this.maps_[0], baseMapIndex, level, baseMapIndex, 0.0);
        }
        Map map = this.maps_[level];
        int index = map.findOrInsertKey(key);
        double estimate = map.update(index, coupon);
        if (estimate > 0.0) {
            return estimate;
        }
        return this.promote(key, coupon, map, index, level, baseMapIndex, -estimate);
    }

    public double getEstimate(byte[] key) {
        if (key == null) {
            return Double.NaN;
        }
        this.checkMethodKeySize(key);
        double est = this.maps_[0].getEstimate(key);
        if (est >= 0.0) {
            return est;
        }
        int level = -((int)est);
        Map map = this.maps_[level];
        return map.getEstimate(key);
    }

    public double getUpperBound(byte[] key) {
        if (key == null) {
            return Double.NaN;
        }
        this.checkMethodKeySize(key);
        double est = this.maps_[0].getEstimate(key);
        if (est >= 0.0) {
            return est;
        }
        int level = -((int)est);
        Map map = this.maps_[level];
        return map.getUpperBound(key);
    }

    public double getLowerBound(byte[] key) {
        if (key == null) {
            return Double.NaN;
        }
        this.checkMethodKeySize(key);
        double est = this.maps_[0].getEstimate(key);
        if (est >= 0.0) {
            return est;
        }
        int level = -((int)est);
        Map map = this.maps_[level];
        return map.getLowerBound(key);
    }

    public int getActiveEntries() {
        return this.maps_[0].getCurrentCountEntries();
    }

    public long getMemoryUsageBytes() {
        long total = 0L;
        for (int i = 0; i < this.maps_.length; ++i) {
            if (this.maps_[i] == null) continue;
            total += this.maps_[i].getMemoryUsageBytes();
        }
        return total;
    }

    public long getKeyMemoryUsageBytes() {
        long total = 0L;
        for (int i = 0; i < this.maps_.length; ++i) {
            if (this.maps_[i] == null) continue;
            total += (long)(this.maps_[i].getActiveEntries() * this.keySizeBytes_);
        }
        return total;
    }

    public double getAverageSketchMemoryPerKey() {
        return (double)(this.getMemoryUsageBytes() - this.getKeyMemoryUsageBytes()) / (double)this.getActiveEntries();
    }

    int getActiveMaps() {
        int levels = 0;
        int iMapsLen = this.maps_.length;
        for (int i = 0; i < iMapsLen; ++i) {
            if (this.maps_[i] == null) continue;
            ++levels;
        }
        return levels;
    }

    Map getBaseMap() {
        return this.maps_[0];
    }

    Map getHllMap() {
        return this.maps_[this.maps_.length - 1];
    }

    public String toString() {
        long totKeys = this.getActiveEntries();
        long totMem = this.getMemoryUsageBytes();
        long keyMem = this.getKeyMemoryUsageBytes();
        double avgValMemPerKey = this.getAverageSketchMemoryPerKey();
        String ksb = Map.fmtLong(this.keySizeBytes_);
        String alvls = Map.fmtLong(this.getActiveMaps());
        String tKeys = Map.fmtLong(totKeys);
        String tMem = Map.fmtLong(totMem);
        String kMem = Map.fmtLong(keyMem);
        String avgValMem = Map.fmtDouble(avgValMemPerKey);
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append("## ").append(thisSimpleName).append(" SUMMARY: ").append(LS);
        sb.append("   Key Size Bytes             : ").append(ksb).append(LS);
        sb.append("   Active Map Levels          : ").append(alvls).append(LS);
        sb.append("   Total keys                 : ").append(tKeys).append(LS);
        sb.append("   Total Memory Bytes         : ").append(tMem).append(LS);
        sb.append("   Total Key Memory Bytes     : ").append(kMem).append(LS);
        sb.append("   Avg Sketch Memory Bytes/Key: ").append(avgValMem).append(LS);
        sb.append(LS);
        for (int i = 0; i < this.maps_.length; ++i) {
            Map cMap = this.maps_[i];
            if (cMap == null) continue;
            sb.append(cMap.toString());
            sb.append(LS);
        }
        sb.append("## ").append("END UNIQUE COUNT MAP SUMMARY");
        sb.append(LS);
        return sb.toString();
    }

    private void setLevelInBaseMap(int index, int level) {
        ((SingleCouponMap)this.maps_[0]).setLevel(index, level);
    }

    private double promote(byte[] key, short coupon, Map fromMap, int fromIndex, int fromLevel, int baseMapIndex, double estimate) {
        Map newMap = this.getMapForLevel(fromLevel + 1);
        int newMapIndex = newMap.findOrInsertKey(key);
        CouponsIterator it = fromMap.getCouponsIterator(fromIndex);
        while (it.next()) {
            double est = newMap.update(newMapIndex, it.getValue());
            assert (est > 0.0);
        }
        fromMap.deleteKey(fromIndex);
        newMap.updateEstimate(newMapIndex, estimate);
        double newEstimate = newMap.update(newMapIndex, coupon);
        this.setLevelInBaseMap(baseMapIndex, fromLevel + 1);
        assert (newEstimate > 0.0);
        return newEstimate;
    }

    private Map getMapForLevel(int level) {
        if (this.maps_[level] == null) {
            int newLevelCapacity = 1 << level;
            this.maps_[level] = level <= 3 ? CouponTraverseMap.getInstance(this.keySizeBytes_, newLevelCapacity) : (level < this.maps_.length - 1 ? CouponHashMap.getInstance(this.keySizeBytes_, newLevelCapacity) : HllMap.getInstance(this.keySizeBytes_, 1024));
        }
        return this.maps_[level];
    }

    private static final void checkConstructorKeySize(int keySizeBytes) {
        if (keySizeBytes < 4) {
            throw new SketchesArgumentException("KeySizeBytes must be >= 4: " + keySizeBytes);
        }
    }

    private final void checkMethodKeySize(byte[] key) {
        if (key.length != this.keySizeBytes_) {
            throw new SketchesArgumentException("Key size must be " + this.keySizeBytes_ + " bytes.");
        }
    }
}

