/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.hll;

import com.iterable.shade.com.yahoo.memory.NativeMemory;
import com.iterable.shade.com.yahoo.sketches.SketchesArgumentException;
import com.iterable.shade.com.yahoo.sketches.hll.BucketIterator;
import com.iterable.shade.com.yahoo.sketches.hll.Fields;
import com.iterable.shade.com.yahoo.sketches.hll.HashUtils;
import com.iterable.shade.com.yahoo.sketches.hll.OnHeapHash;
import com.iterable.shade.com.yahoo.sketches.hll.Preamble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

final class OnHeapImmutableCompactFields
implements Fields {
    private final Preamble preamble;
    private final int[] fields;

    public static OnHeapImmutableCompactFields fromFields(Fields fields) {
        ArrayList<Integer> vals = new ArrayList<Integer>();
        BucketIterator iter = fields.getBucketIterator();
        while (iter.next()) {
            vals.add(HashUtils.pairOfKeyAndVal(iter.getKey(), iter.getValue()));
        }
        Collections.sort(vals, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return HashUtils.valOfPair(o2) - HashUtils.valOfPair(o1);
            }
        });
        int[] theFields = new int[vals.size()];
        int count = 0;
        for (Integer val : vals) {
            theFields[count++] = val;
        }
        return new OnHeapImmutableCompactFields(fields.getPreamble(), theFields);
    }

    OnHeapImmutableCompactFields(Preamble preamble, int[] fields) {
        this.preamble = preamble;
        this.fields = fields;
    }

    @Override
    public Preamble getPreamble() {
        return this.preamble;
    }

    @Override
    public Fields updateBucket(int i, byte val, Fields.UpdateCallback cb) {
        throw new UnsupportedOperationException("Cannot mutate a compact sketch");
    }

    @Override
    public int intoByteArray(byte[] array, int offset) {
        int numBytesNeeded = this.numBytesToSerialize();
        if (array.length - offset < numBytesNeeded) {
            throw new SketchesArgumentException(String.format("array too small[%,d] < [%,d]", array.length - offset, numBytesNeeded));
        }
        NativeMemory mem = new NativeMemory(array);
        mem.putByte(offset++, (byte)2);
        for (int field : this.fields) {
            mem.putInt(offset, field);
            offset += 4;
        }
        return offset;
    }

    @Override
    public int numBytesToSerialize() {
        return 1 + (this.fields.length << 2);
    }

    @Override
    public Fields toCompact() {
        return this;
    }

    @Override
    public BucketIterator getBucketIterator() {
        return new BucketIterator(){
            int i = -1;

            @Override
            public boolean next() {
                return ++this.i < OnHeapImmutableCompactFields.this.fields.length;
            }

            @Override
            public int getKey() {
                return HashUtils.keyOfPair(OnHeapImmutableCompactFields.this.fields[this.i]);
            }

            @Override
            public byte getValue() {
                return HashUtils.valOfPair(OnHeapImmutableCompactFields.this.fields[this.i]);
            }
        };
    }

    @Override
    public Fields unionInto(Fields recipient, Fields.UpdateCallback cb) {
        return recipient.unionBucketIterator(this.getBucketIterator(), cb);
    }

    @Override
    public Fields unionBucketIterator(BucketIterator iter, Fields.UpdateCallback cb) {
        throw new UnsupportedOperationException("Cannot mutate a compact sketch");
    }

    @Override
    public Fields unionCompressedAndExceptions(byte[] compressed, int minVal, OnHeapHash exceptions, Fields.UpdateCallback cb) {
        throw new UnsupportedOperationException("Cannot mutate a compact sketch");
    }
}

