/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.hll;

import com.iterable.shade.com.yahoo.sketches.SketchesArgumentException;
import com.iterable.shade.com.yahoo.sketches.hash.MurmurHash3;
import com.iterable.shade.com.yahoo.sketches.hll.CouponsIterator;
import com.iterable.shade.com.yahoo.sketches.hll.Map;
import java.util.Arrays;

final class CouponTraverseMap
extends Map {
    private static final double RSE = 0.408 / Math.sqrt(1024.0);
    private final int maxCouponsPerKey_;
    private int tableEntries_;
    private int capacityEntries_;
    private int numActiveKeys_;
    private int numDeletedKeys_;
    private double entrySizeBytes_;
    private byte[] keysArr_;
    private short[] couponsArr_;
    private byte[] stateArr_;

    private CouponTraverseMap(int keySizeBytes, int maxCouponsPerKey) {
        super(keySizeBytes);
        this.maxCouponsPerKey_ = maxCouponsPerKey;
    }

    static CouponTraverseMap getInstance(int keySizeBytes, int maxCouponsPerKey) {
        CouponTraverseMap map = new CouponTraverseMap(keySizeBytes, maxCouponsPerKey);
        map.tableEntries_ = 157;
        map.capacityEntries_ = (int)((double)map.tableEntries_ * 0.9375);
        map.numActiveKeys_ = 0;
        map.numDeletedKeys_ = 0;
        map.entrySizeBytes_ = CouponTraverseMap.updateEntrySizeBytes(map.tableEntries_, keySizeBytes, maxCouponsPerKey);
        map.keysArr_ = new byte[157 * keySizeBytes];
        map.couponsArr_ = new short[157 * maxCouponsPerKey];
        map.stateArr_ = new byte[(int)Math.ceil(19.625)];
        return map;
    }

    @Override
    double update(byte[] key, short coupon) {
        int entryIndex = this.findOrInsertKey(key);
        return this.update(entryIndex, coupon);
    }

    @Override
    double update(int entryIndex, short value) {
        int offset = entryIndex * this.maxCouponsPerKey_;
        boolean wasFound = false;
        for (int i = 0; i < this.maxCouponsPerKey_; ++i) {
            if (this.couponsArr_[offset + i] == 0) {
                if (wasFound) {
                    return i;
                }
                this.couponsArr_[offset + i] = value;
                return i + 1;
            }
            if (this.couponsArr_[offset + i] != value) continue;
            wasFound = true;
        }
        if (wasFound) {
            return this.maxCouponsPerKey_;
        }
        return -this.maxCouponsPerKey_;
    }

    @Override
    double getEstimate(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            return 0.0;
        }
        return this.getCouponCount(entryIndex);
    }

    @Override
    double getUpperBound(byte[] key) {
        return this.getEstimate(key) * (1.0 + RSE);
    }

    @Override
    double getLowerBound(byte[] key) {
        return this.getEstimate(key) * (1.0 - RSE);
    }

    @Override
    int findKey(byte[] key) {
        long[] hash = MurmurHash3.hash(key, 1234567890L);
        int entryIndex = CouponTraverseMap.getIndex(hash[0], this.tableEntries_);
        int firstDeletedIndex = -1;
        int loopIndex = entryIndex;
        do {
            if (CouponTraverseMap.isBitClear(this.stateArr_, entryIndex)) {
                return firstDeletedIndex == -1 ? ~entryIndex : ~firstDeletedIndex;
            }
            if (this.couponsArr_[entryIndex * this.maxCouponsPerKey_] == 0) {
                if (firstDeletedIndex != -1) continue;
                firstDeletedIndex = entryIndex;
                continue;
            }
            if (!Map.arraysEqual(this.keysArr_, entryIndex * this.keySizeBytes_, key, 0, this.keySizeBytes_)) continue;
            return entryIndex;
        } while ((entryIndex = (entryIndex + CouponTraverseMap.getStride(hash[1], this.tableEntries_)) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    @Override
    int findOrInsertKey(byte[] key) {
        int entryIndex = this.findKey(key);
        if (entryIndex < 0) {
            if (CouponTraverseMap.isBitSet(this.stateArr_, entryIndex ^= 0xFFFFFFFF)) {
                this.clearCouponArea(entryIndex);
                --this.numDeletedKeys_;
            }
            if (this.numActiveKeys_ + this.numDeletedKeys_ + 1 > this.capacityEntries_) {
                this.resize();
                entryIndex = ~this.findKey(key);
                assert (entryIndex >= 0);
            }
            System.arraycopy(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_);
            CouponTraverseMap.setBit(this.stateArr_, entryIndex);
            ++this.numActiveKeys_;
        }
        return entryIndex;
    }

    @Override
    void deleteKey(int entryIndex) {
        this.couponsArr_[entryIndex * this.maxCouponsPerKey_] = 0;
        --this.numActiveKeys_;
        ++this.numDeletedKeys_;
        if (this.numActiveKeys_ > 157 && (double)this.numActiveKeys_ < (double)this.tableEntries_ * 0.5) {
            this.resize();
        }
    }

    private int getCouponCount(int entryIndex) {
        int offset = entryIndex * this.maxCouponsPerKey_;
        for (int i = 0; i < this.maxCouponsPerKey_; ++i) {
            if (this.couponsArr_[offset + i] != 0) continue;
            return i;
        }
        return this.maxCouponsPerKey_;
    }

    @Override
    CouponsIterator getCouponsIterator(int entryIndex) {
        return new CouponsIterator(this.couponsArr_, entryIndex * this.maxCouponsPerKey_, this.maxCouponsPerKey_);
    }

    @Override
    double getEntrySizeBytes() {
        return this.entrySizeBytes_;
    }

    @Override
    int getTableEntries() {
        return this.tableEntries_;
    }

    @Override
    int getCapacityEntries() {
        return this.capacityEntries_;
    }

    @Override
    int getCurrentCountEntries() {
        return this.numActiveKeys_ + this.numDeletedKeys_;
    }

    @Override
    long getMemoryUsageBytes() {
        return (long)this.keysArr_.length + (long)this.couponsArr_.length * 2L + (long)this.stateArr_.length + 16L;
    }

    @Override
    int getActiveEntries() {
        return this.numActiveKeys_;
    }

    @Override
    int getDeletedEntries() {
        return this.numDeletedKeys_;
    }

    @Override
    int getMaxCouponsPerEntry() {
        return this.maxCouponsPerKey_;
    }

    @Override
    int getCapacityCouponsPerEntry() {
        return this.maxCouponsPerKey_;
    }

    private void resize() {
        byte[] oldKeysArr = this.keysArr_;
        short[] oldCouponsArr = this.couponsArr_;
        byte[] oldStateArr = this.stateArr_;
        int oldSizeKeys = this.tableEntries_;
        this.tableEntries_ = Math.max(CouponTraverseMap.nextPrime((int)((double)this.numActiveKeys_ / 0.6666666666666666)), 157);
        this.capacityEntries_ = (int)((double)this.tableEntries_ * 0.9375);
        this.numActiveKeys_ = 0;
        this.numDeletedKeys_ = 0;
        this.entrySizeBytes_ = CouponTraverseMap.updateEntrySizeBytes(this.tableEntries_, this.keySizeBytes_, this.maxCouponsPerKey_);
        this.keysArr_ = new byte[this.tableEntries_ * this.keySizeBytes_];
        this.couponsArr_ = new short[this.tableEntries_ * this.maxCouponsPerKey_];
        this.stateArr_ = new byte[(int)Math.ceil((double)this.tableEntries_ / 8.0)];
        for (int i = 0; i < oldSizeKeys; ++i) {
            if (!CouponTraverseMap.isBitSet(oldStateArr, i) || oldCouponsArr[i * this.maxCouponsPerKey_] == 0) continue;
            byte[] key = Arrays.copyOfRange(oldKeysArr, i * this.keySizeBytes_, i * this.keySizeBytes_ + this.keySizeBytes_);
            int index = this.insertKey(key);
            System.arraycopy(oldCouponsArr, i * this.maxCouponsPerKey_, this.couponsArr_, index * this.maxCouponsPerKey_, this.maxCouponsPerKey_);
        }
    }

    private int insertKey(byte[] key) {
        int entryIndex;
        long[] hash = MurmurHash3.hash(key, 1234567890L);
        int loopIndex = entryIndex = CouponTraverseMap.getIndex(hash[0], this.tableEntries_);
        do {
            if (!CouponTraverseMap.isBitClear(this.stateArr_, entryIndex)) continue;
            System.arraycopy(key, 0, this.keysArr_, entryIndex * this.keySizeBytes_, this.keySizeBytes_);
            CouponTraverseMap.setBit(this.stateArr_, entryIndex);
            ++this.numActiveKeys_;
            return entryIndex;
        } while ((entryIndex = (entryIndex + CouponTraverseMap.getStride(hash[1], this.tableEntries_)) % this.tableEntries_) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }

    private void clearCouponArea(int entryIndex) {
        int couponAreaIndex = entryIndex * this.maxCouponsPerKey_;
        for (int i = 0; i < this.maxCouponsPerKey_; ++i) {
            this.couponsArr_[couponAreaIndex + i] = 0;
        }
    }

    private static final double updateEntrySizeBytes(int tableEntries, int keySizeBytes, int maxCouponsPerKey) {
        double byteFraction = Math.ceil((double)tableEntries / 8.0) / (double)tableEntries;
        return (double)(keySizeBytes + maxCouponsPerKey * 2) + byteFraction;
    }
}

