/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.yahoo.sketches.frequencies;

import com.iterable.shade.com.yahoo.memory.Memory;
import com.iterable.shade.com.yahoo.memory.NativeMemory;
import com.iterable.shade.com.yahoo.sketches.Family;
import com.iterable.shade.com.yahoo.sketches.SketchesArgumentException;
import com.iterable.shade.com.yahoo.sketches.SketchesStateException;
import com.iterable.shade.com.yahoo.sketches.Util;
import com.iterable.shade.com.yahoo.sketches.frequencies.ErrorType;
import com.iterable.shade.com.yahoo.sketches.frequencies.PreambleUtil;
import com.iterable.shade.com.yahoo.sketches.frequencies.ReversePurgeLongHashMap;
import java.util.ArrayList;
import java.util.Comparator;

public class LongsSketch {
    private static final int STR_PREAMBLE_TOKENS = 6;
    private int lgMaxMapSize;
    private int curMapCap;
    private long offset;
    private long streamLength = 0L;
    private int sampleSize;
    private ReversePurgeLongHashMap hashMap;

    public LongsSketch(int maxMapSize) {
        this(Util.toLog2(maxMapSize, "maxMapSize"), 3);
    }

    LongsSketch(int lgMaxMapSize, int lgCurMapSize) {
        this.lgMaxMapSize = Math.max(lgMaxMapSize, 3);
        int lgCurMapSz = Math.max(lgCurMapSize, 3);
        this.hashMap = new ReversePurgeLongHashMap(1 << lgCurMapSz);
        this.curMapCap = this.hashMap.getCapacity();
        int maxMapCap = (int)((double)(1 << lgMaxMapSize) * ReversePurgeLongHashMap.getLoadFactor());
        this.offset = 0L;
        this.sampleSize = Math.min(1024, maxMapCap);
    }

    public static LongsSketch getInstance(Memory srcMem) {
        boolean preLongsEqMax;
        long pre0 = PreambleUtil.checkPreambleSize(srcMem);
        int maxPreLongs = Family.FREQUENCY.getMaxPreLongs();
        int preLongs = PreambleUtil.extractPreLongs(pre0);
        int serVer = PreambleUtil.extractSerVer(pre0);
        int familyID = PreambleUtil.extractFamilyID(pre0);
        int lgMaxMapSize = PreambleUtil.extractLgMaxMapSize(pre0);
        int lgCurMapSize = PreambleUtil.extractLgCurMapSize(pre0);
        boolean empty = (PreambleUtil.extractFlags(pre0) & 4) != 0;
        boolean preLongsEq1 = preLongs == 1;
        boolean bl = preLongsEqMax = preLongs == maxPreLongs;
        if (!preLongsEq1 && !preLongsEqMax) {
            throw new SketchesArgumentException("Possible Corruption: PreLongs must be 1 or " + maxPreLongs + ": " + preLongs);
        }
        if (serVer != 1) {
            throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 1: " + serVer);
        }
        int actFamID = Family.FREQUENCY.getID();
        if (familyID != actFamID) {
            throw new SketchesArgumentException("Possible Corruption: FamilyID must be " + actFamID + ": " + familyID);
        }
        if (empty ^ preLongsEq1) {
            throw new SketchesArgumentException("Possible Corruption: (PreLongs == 1) ^ Empty == True.");
        }
        if (empty) {
            return new LongsSketch(lgMaxMapSize, 3);
        }
        long[] preArr = new long[preLongs];
        srcMem.getLongArray(0L, preArr, 0, preLongs);
        LongsSketch fls = new LongsSketch(lgMaxMapSize, lgCurMapSize);
        fls.streamLength = 0L;
        fls.offset = preArr[3];
        int preBytes = preLongs << 3;
        int activeItems = PreambleUtil.extractActiveItems(preArr[1]);
        long[] countArray = new long[activeItems];
        srcMem.getLongArray(preBytes, countArray, 0, activeItems);
        int itemsOffset = preBytes + 8 * activeItems;
        long[] itemArray = new long[activeItems];
        srcMem.getLongArray(itemsOffset, itemArray, 0, activeItems);
        for (int i = 0; i < activeItems; ++i) {
            fls.update(itemArray[i], countArray[i]);
        }
        fls.streamLength = preArr[2];
        return fls;
    }

    public static LongsSketch getInstance(String string) {
        boolean zeroStream;
        String[] tokens = string.split(",");
        if (tokens.length < 8) {
            throw new SketchesArgumentException("String not long enough: " + tokens.length);
        }
        int serVer = Integer.parseInt(tokens[0]);
        int famID = Integer.parseInt(tokens[1]);
        int lgMax = Integer.parseInt(tokens[2]);
        int flags = Integer.parseInt(tokens[3]);
        long streamLength = Long.parseLong(tokens[4]);
        long offset = Long.parseLong(tokens[5]);
        int numActive = Integer.parseInt(tokens[6]);
        int lgCur = Integer.numberOfTrailingZeros(Integer.parseInt(tokens[7]));
        if (serVer != 1) {
            throw new SketchesArgumentException("Possible Corruption: Bad SerVer: " + serVer);
        }
        Family.FREQUENCY.checkFamilyID(famID);
        boolean empty = flags > 0;
        boolean bl = zeroStream = streamLength == 0L;
        if (empty ^ zeroStream) {
            throw new SketchesArgumentException("Possible Corruption: (Empty ^ StreamLength=0) = true : Empty: " + empty + ", strLen: " + streamLength);
        }
        int numTokens = tokens.length;
        if (2 * numActive != numTokens - 6 - 2) {
            throw new SketchesArgumentException("Possible Corruption: Incorrect # of tokens: " + numTokens + ", numActive: " + numActive);
        }
        LongsSketch sketch = new LongsSketch(lgMax, lgCur);
        sketch.streamLength = streamLength;
        sketch.offset = offset;
        sketch.hashMap = LongsSketch.deserializeFromStringArray(tokens);
        return sketch;
    }

    public String serializeToString() {
        StringBuilder sb = new StringBuilder();
        boolean serVer = true;
        int famID = Family.FREQUENCY.getID();
        int lgMaxMapSz = this.lgMaxMapSize;
        int flags = this.hashMap.getNumActive() == 0 ? 4 : 0;
        String fmt = "%d,%d,%d,%d,%d,%d,";
        String s2 = String.format("%d,%d,%d,%d,%d,%d,", 1, famID, lgMaxMapSz, flags, this.streamLength, this.offset);
        sb.append(s2);
        sb.append(this.hashMap.serializeToString());
        return sb.toString();
    }

    public byte[] toByteArray() {
        int outBytes;
        int preLongs;
        boolean empty = this.isEmpty();
        int activeItems = this.getNumActiveItems();
        if (empty) {
            preLongs = 1;
            outBytes = 8;
        } else {
            preLongs = Family.FREQUENCY.getMaxPreLongs();
            outBytes = preLongs + 2 * activeItems << 3;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(preLongs, pre0);
        pre0 = PreambleUtil.insertSerVer(1, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.FREQUENCY.getID(), pre0);
        pre0 = PreambleUtil.insertLgMaxMapSize(this.lgMaxMapSize, pre0);
        pre0 = PreambleUtil.insertLgCurMapSize(this.hashMap.getLgLength(), pre0);
        long l = pre0 = empty ? PreambleUtil.insertFlags(4, pre0) : PreambleUtil.insertFlags(0, pre0);
        if (empty) {
            mem.putLong(0L, pre0);
        } else {
            long pre = 0L;
            long[] preArr = new long[preLongs];
            preArr[0] = pre0;
            preArr[1] = PreambleUtil.insertActiveItems(activeItems, 0L);
            preArr[2] = this.streamLength;
            preArr[3] = this.offset;
            mem.putLongArray(0L, preArr, 0, preLongs);
            int preBytes = preLongs << 3;
            mem.putLongArray(preBytes, this.hashMap.getActiveValues(), 0, activeItems);
            mem.putLongArray(preBytes + (activeItems << 3), this.hashMap.getActiveKeys(), 0, activeItems);
        }
        return outArr;
    }

    public void update(long item) {
        this.update(item, 1L);
    }

    public void update(long item, long count) {
        if (count == 0L) {
            return;
        }
        if (count < 0L) {
            throw new SketchesArgumentException("Count may not be negative");
        }
        this.streamLength += count;
        this.hashMap.adjustOrPutValue(item, count);
        if (this.getNumActiveItems() > this.curMapCap) {
            if (this.hashMap.getLgLength() < this.lgMaxMapSize) {
                this.hashMap.resize(2 * this.hashMap.getLength());
                this.curMapCap = this.hashMap.getCapacity();
            } else {
                this.offset += this.hashMap.purge(this.sampleSize);
                if (this.getNumActiveItems() > this.getMaximumMapCapacity()) {
                    throw new SketchesStateException("Purge did not reduce active items.");
                }
            }
        }
    }

    public LongsSketch merge(LongsSketch other) {
        if (other == null) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        long streamLen = this.streamLength + other.streamLength;
        ReversePurgeLongHashMap.Iterator iter = other.hashMap.iterator();
        while (iter.next()) {
            this.update(iter.getKey(), iter.getValue());
        }
        this.offset += other.offset;
        this.streamLength = streamLen;
        return this;
    }

    public long getEstimate(long item) {
        long itemCount = this.hashMap.get(item);
        return itemCount > 0L ? itemCount + this.offset : 0L;
    }

    public long getUpperBound(long item) {
        return this.hashMap.get(item) + this.offset;
    }

    public long getLowerBound(long item) {
        return this.hashMap.get(item);
    }

    public Row[] getFrequentItems(ErrorType errorType) {
        return this.sortItems(this.getMaximumError(), errorType);
    }

    Row[] sortItems(long threshold, ErrorType errorType) {
        long est;
        ArrayList<Row> rowList = new ArrayList<Row>();
        ReversePurgeLongHashMap.Iterator iter = this.hashMap.iterator();
        if (errorType == ErrorType.NO_FALSE_NEGATIVES) {
            while (iter.next()) {
                est = this.getEstimate(iter.getKey());
                long ub = this.getUpperBound(iter.getKey());
                long lb = this.getLowerBound(iter.getKey());
                if (ub < threshold) continue;
                Row row = new Row(iter.getKey(), est, ub, lb);
                rowList.add(row);
            }
        } else {
            while (iter.next()) {
                est = this.getEstimate(iter.getKey());
                long ub = this.getUpperBound(iter.getKey());
                long lb = this.getLowerBound(iter.getKey());
                if (lb < threshold) continue;
                Row row = new Row(iter.getKey(), est, ub, lb);
                rowList.add(row);
            }
        }
        rowList.sort(new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return r2.compareTo(r1);
            }
        });
        Row[] rowsArr = rowList.toArray(new Row[rowList.size()]);
        return rowsArr;
    }

    public int getCurrentMapCapacity() {
        return this.curMapCap;
    }

    public long getMaximumError() {
        return this.offset;
    }

    public boolean isEmpty() {
        return this.getNumActiveItems() == 0;
    }

    public long getStreamLength() {
        return this.streamLength;
    }

    public int getMaximumMapCapacity() {
        return (int)((double)(1 << this.lgMaxMapSize) * ReversePurgeLongHashMap.getLoadFactor());
    }

    public int getNumActiveItems() {
        return this.hashMap.getNumActive();
    }

    public int getStorageBytes() {
        if (this.isEmpty()) {
            return 8;
        }
        return 48 + 16 * this.getNumActiveItems();
    }

    public void reset() {
        this.hashMap = new ReversePurgeLongHashMap(8);
        this.curMapCap = this.hashMap.getCapacity();
        this.offset = 0L;
        this.streamLength = 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FrequentLongsSketch:").append(Util.LS);
        sb.append("  Stream Length    : " + this.streamLength).append(Util.LS);
        sb.append("  Max Error Offset : " + this.offset).append(Util.LS);
        sb.append(this.hashMap.toString());
        return sb.toString();
    }

    static ReversePurgeLongHashMap deserializeFromStringArray(String[] tokens) {
        int ignore = 6;
        int numActive = Integer.parseInt(tokens[6]);
        int length = Integer.parseInt(tokens[7]);
        ReversePurgeLongHashMap hashMap = new ReversePurgeLongHashMap(length);
        int j = 8;
        for (int i = 0; i < numActive; ++i) {
            long key = Long.parseLong(tokens[j++]);
            long value = Long.parseLong(tokens[j++]);
            hashMap.adjustOrPutValue(key, value);
        }
        return hashMap;
    }

    public static class Row
    implements Comparable<Row> {
        final long item;
        final long est;
        final long ub;
        final long lb;
        private static final String fmt = "  %20d%20d%20d %d";
        private static final String hfmt = "  %20s%20s%20s %s";

        Row(long item, long estimate, long ub, long lb) {
            this.item = item;
            this.est = estimate;
            this.ub = ub;
            this.lb = lb;
        }

        public long getItem() {
            return this.item;
        }

        public long getEstimate() {
            return this.est;
        }

        public long getUpperBound() {
            return this.ub;
        }

        public long getLowerBound() {
            return this.lb;
        }

        public static String getRowHeader() {
            return String.format(hfmt, "Est", "UB", "LB", "Item");
        }

        public String toString() {
            return String.format(fmt, this.est, this.ub, this.lb, this.item);
        }

        @Override
        public int compareTo(Row that) {
            return this.est < that.est ? -1 : (this.est > that.est ? 1 : 0);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.est ^ this.est >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Row)) {
                return false;
            }
            Row that = (Row)obj;
            return this.est == that.est;
        }
    }
}

