/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.spotify.futures;

import com.iterable.shade.com.spotify.futures.CompletableFutures;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;

public class ConcurrencyReducer<T> {
    private final BlockingQueue<Job<T>> queue;
    private final Semaphore limit;
    private final int maxQueueSize;
    private final int maxConcurrency;

    private ConcurrencyReducer(int maxConcurrency, int maxQueueSize) {
        this.maxConcurrency = maxConcurrency;
        this.maxQueueSize = maxQueueSize;
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency must be at least 0");
        }
        if (maxQueueSize <= 0) {
            throw new IllegalArgumentException("maxQueueSize must be at least 0");
        }
        this.queue = new ArrayBlockingQueue<Job<T>>(maxQueueSize);
        this.limit = new Semaphore(maxConcurrency);
    }

    public static <T> ConcurrencyReducer<T> create(int maxConcurrency, int maxQueueSize) {
        return new ConcurrencyReducer<T>(maxConcurrency, maxQueueSize);
    }

    public CompletableFuture<T> add(Callable<? extends CompletionStage<T>> callable) {
        Objects.requireNonNull(callable);
        CompletableFuture response = new CompletableFuture();
        Job job = new Job(callable, response);
        if (!this.queue.offer(job)) {
            String message = "Queue size has reached capacity: " + this.maxQueueSize;
            return CompletableFutures.exceptionallyCompletedFuture(new CapacityReachedException(message));
        }
        this.pump();
        return response;
    }

    public int numQueued() {
        return this.queue.size();
    }

    public int numActive() {
        return this.maxConcurrency - this.limit.availablePermits();
    }

    public int remainingQueueCapacity() {
        return this.queue.remainingCapacity();
    }

    public int remainingActiveCapacity() {
        return this.limit.availablePermits();
    }

    private Job<T> grabJob() {
        if (!this.limit.tryAcquire()) {
            return null;
        }
        Job job = (Job)this.queue.poll();
        if (job != null) {
            return job;
        }
        this.limit.release();
        return null;
    }

    private void pump() {
        Job<T> job;
        while ((job = this.grabJob()) != null) {
            CompletableFuture response = ((Job)job).response;
            if (response.isCancelled()) {
                this.limit.release();
                continue;
            }
            this.invoke(response, ((Job)job).callable);
        }
    }

    private void invoke(CompletableFuture<T> response, Callable<? extends CompletionStage<T>> callable) {
        CompletionStage<Object> future;
        try {
            future = callable.call();
            if (future == null) {
                this.limit.release();
                response.completeExceptionally(new NullPointerException());
                return;
            }
        }
        catch (Throwable e) {
            this.limit.release();
            response.completeExceptionally(e);
            return;
        }
        future.whenComplete((result, t2) -> {
            if (t2 != null) {
                this.limit.release();
                response.completeExceptionally((Throwable)t2);
                this.pump();
            } else {
                this.limit.release();
                response.complete(result);
                this.pump();
            }
        });
    }

    private static class Job<T> {
        private final Callable<? extends CompletionStage<T>> callable;
        private final CompletableFuture<T> response;

        public Job(Callable<? extends CompletionStage<T>> callable, CompletableFuture<T> response) {
            this.callable = callable;
            this.response = response;
        }
    }

    public static class CapacityReachedException
    extends RuntimeException {
        public CapacityReachedException(String errorMessage) {
            super(errorMessage);
        }
    }
}

