/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.google.common.collect;

import com.iterable.shade.com.google.common.annotations.GwtCompatible;
import com.iterable.shade.com.google.common.base.Predicate;
import com.iterable.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.iterable.shade.com.google.common.collect.FilteredEntryMultimap;
import com.iterable.shade.com.google.common.collect.FilteredSetMultimap;
import com.iterable.shade.com.google.common.collect.ParametricNullness;
import com.iterable.shade.com.google.common.collect.SetMultimap;
import com.iterable.shade.com.google.common.collect.Sets;
import com.iterable.shade.javax.annotation.CheckForNull;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredEntrySetMultimap<K, V>
extends FilteredEntryMultimap<K, V>
implements FilteredSetMultimap<K, V> {
    FilteredEntrySetMultimap(SetMultimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        super(unfiltered, predicate);
    }

    @Override
    public SetMultimap<K, V> unfiltered() {
        return (SetMultimap)this.unfiltered;
    }

    @Override
    public Set<V> get(@ParametricNullness K key) {
        return (Set)super.get(key);
    }

    @Override
    public Set<V> removeAll(@CheckForNull Object key) {
        return (Set)super.removeAll(key);
    }

    @Override
    public Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        return (Set)super.replaceValues(key, values);
    }

    @Override
    Set<Map.Entry<K, V>> createEntries() {
        return Sets.filter(this.unfiltered().entries(), this.entryPredicate());
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }
}

