/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.google.common.collect;

import com.iterable.shade.com.google.common.annotations.GwtCompatible;
import com.iterable.shade.com.google.common.base.Preconditions;
import com.iterable.shade.com.google.common.collect.AbstractIterator;
import com.iterable.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.iterable.shade.javax.annotation.CheckForNull;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

