/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories;

import com.iterable.shade.com.fasterxml.jackson.databind.JavaType;
import com.iterable.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.iterable.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.FormatVisitorFactory;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.StringSchema;

public class SchemaFactoryWrapper
implements JsonFormatVisitorWrapper,
Visitor {
    protected FormatVisitorFactory visitorFactory;
    protected JsonSchemaFactory schemaProvider;
    protected SerializerProvider provider;
    protected JsonSchema schema;
    protected VisitorContext visitorContext;

    public SchemaFactoryWrapper() {
        this(null, new WrapperFactory());
    }

    public SchemaFactoryWrapper(SerializerProvider p) {
        this(p, new WrapperFactory());
    }

    protected SchemaFactoryWrapper(WrapperFactory wrapperFactory) {
        this(null, wrapperFactory);
    }

    protected SchemaFactoryWrapper(SerializerProvider p, WrapperFactory wrapperFactory) {
        this.provider = p;
        this.schemaProvider = new JsonSchemaFactory();
        this.visitorFactory = new FormatVisitorFactory(wrapperFactory);
    }

    @Override
    public SerializerProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    @Override
    public JsonAnyFormatVisitor expectAnyFormat(JavaType convertedType) {
        AnySchema s2 = this.schemaProvider.anySchema();
        this.schema = s2;
        return this.visitorFactory.anyFormatVisitor(s2);
    }

    @Override
    public JsonArrayFormatVisitor expectArrayFormat(JavaType convertedType) {
        ArraySchema s2 = this.schemaProvider.arraySchema();
        this.schema = s2;
        return this.visitorFactory.arrayFormatVisitor(this.provider, s2, this.visitorContext);
    }

    @Override
    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType convertedType) {
        BooleanSchema s2 = this.schemaProvider.booleanSchema();
        this.schema = s2;
        return this.visitorFactory.booleanFormatVisitor(s2);
    }

    @Override
    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType convertedType) {
        IntegerSchema s2 = this.schemaProvider.integerSchema();
        this.schema = s2;
        return this.visitorFactory.integerFormatVisitor(s2);
    }

    @Override
    public JsonNullFormatVisitor expectNullFormat(JavaType convertedType) {
        NullSchema s2 = this.schemaProvider.nullSchema();
        this.schema = s2;
        return this.visitorFactory.nullFormatVisitor(s2);
    }

    @Override
    public JsonNumberFormatVisitor expectNumberFormat(JavaType convertedType) {
        NumberSchema s2 = this.schemaProvider.numberSchema();
        this.schema = s2;
        return this.visitorFactory.numberFormatVisitor(s2);
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        String schemaUri;
        ObjectSchema s2 = this.schemaProvider.objectSchema();
        this.schema = s2;
        if (this.visitorContext == null) {
            this.visitorContext = new VisitorContext();
        }
        if ((schemaUri = this.visitorContext.addSeenSchemaUri(convertedType)) != null) {
            s2.setId(schemaUri);
        }
        return this.visitorFactory.objectFormatVisitor(this.provider, s2, this.visitorContext);
    }

    @Override
    public JsonStringFormatVisitor expectStringFormat(JavaType convertedType) {
        StringSchema s2 = this.schemaProvider.stringSchema();
        this.schema = s2;
        return this.visitorFactory.stringFormatVisitor(s2);
    }

    @Override
    public JsonMapFormatVisitor expectMapFormat(JavaType type) throws JsonMappingException {
        ObjectSchema s2 = this.schemaProvider.objectSchema();
        this.schema = s2;
        return this.visitorFactory.mapFormatVisitor(this.provider, s2, this.visitorContext);
    }

    @Override
    public SchemaFactoryWrapper setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }

    public JsonSchema finalSchema() {
        return this.schema;
    }
}

