/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories;

import com.iterable.shade.com.fasterxml.jackson.databind.JavaType;
import com.iterable.shade.com.fasterxml.jackson.databind.JsonMappingException;
import com.iterable.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.Visitor;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ReferenceSchema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements JsonSchemaProducer,
Visitor {
    protected final ArraySchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory;
    private VisitorContext visitorContext;

    public ArrayVisitor(SerializerProvider provider, ArraySchema schema) {
        this(provider, schema, new WrapperFactory());
    }

    public ArrayVisitor(SerializerProvider provider, ArraySchema schema, WrapperFactory wrapperFactory) {
        this.provider = provider;
        this.schema = schema;
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public SerializerProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public void itemsFormat(JsonFormatVisitable handler, JavaType contentType) throws JsonMappingException {
        if (contentType.getRawClass() != Object.class) {
            String seenSchemaUri;
            if (this.visitorContext != null && (seenSchemaUri = this.visitorContext.getSeenSchemaUri(contentType)) != null) {
                this.schema.setItemsSchema(new ReferenceSchema(seenSchemaUri));
                return;
            }
            SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider(), this.visitorContext);
            handler.acceptJsonFormatVisitor(visitor, contentType);
            this.schema.setItemsSchema(visitor.finalSchema());
        }
    }

    @Override
    public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
        this.schema.setItemsSchema(JsonSchema.minimalForFormat(format));
    }

    @Override
    public Visitor setVisitorContext(VisitorContext rvc) {
        this.visitorContext = rvc;
        return this;
    }
}

