/*
 * Decompiled with CFR 0.152.
 */
package com.iterable.shade.com.fasterxml.jackson.module.jsonSchema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.iterable.shade.com.fasterxml.jackson.databind.DatabindContext;
import com.iterable.shade.com.fasterxml.jackson.databind.JavaType;
import com.iterable.shade.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.iterable.shade.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.iterable.shade.com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.lang.reflect.Type;
import java.util.Arrays;

public class JsonSchemaIdResolver
extends TypeIdResolverBase {
    @Override
    public String idFromValue(Object value) {
        if (value instanceof JsonSchema) {
            return ((JsonSchema)value).getType().value();
        }
        return null;
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    @Override
    public JavaType typeFromId(DatabindContext ctxt, String id) {
        JsonFormatTypes stdType = JsonFormatTypes.forValue(id);
        if (stdType != null) {
            switch (stdType) {
                case ARRAY: {
                    return ctxt.constructType((Type)((Object)ArraySchema.class));
                }
                case BOOLEAN: {
                    return ctxt.constructType((Type)((Object)BooleanSchema.class));
                }
                case INTEGER: {
                    return ctxt.constructType((Type)((Object)IntegerSchema.class));
                }
                case NULL: {
                    return ctxt.constructType((Type)((Object)NullSchema.class));
                }
                case NUMBER: {
                    return ctxt.constructType((Type)((Object)NumberSchema.class));
                }
                case OBJECT: {
                    return ctxt.constructType((Type)((Object)ObjectSchema.class));
                }
                case STRING: {
                    return ctxt.constructType((Type)((Object)StringSchema.class));
                }
            }
            return ctxt.constructType((Type)((Object)AnySchema.class));
        }
        throw new IllegalArgumentException("Can not resolve JsonSchema 'type' id of \"" + id + "\", not recognized as one of standard values: " + Arrays.asList(JsonFormatTypes.values()));
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @Override
    public void init(JavaType baseType) {
    }

    @Override
    public String idFromBaseType() {
        return null;
    }
}

