/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Sink;
import org.apache.pulsar.client.admin.Sinks;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinksImpl
extends ComponentResource
implements Sinks,
Sink {
    private static final Logger log = LoggerFactory.getLogger(SinksImpl.class);
    private final WebTarget sink;
    private final AsyncHttpClient asyncHttpClient;

    public SinksImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.sink = web.path("/admin/v3/sink");
        this.asyncHttpClient = asyncHttpClient;
    }

    public List<String> listSinks(String tenant, String namespace) throws PulsarAdminException {
        try {
            return this.listSinksAsync(tenant, namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<String>> listSinksAsync(String tenant, String namespace) {
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        if (!SinksImpl.validateNamespace(tenant, namespace, future)) {
            return future;
        }
        WebTarget path = this.sink.path(tenant).path(namespace);
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(SinksImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<String>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SinksImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SinkConfig getSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            return this.getSinkAsync(tenant, namespace, sinkName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SinkConfig> getSinkAsync(String tenant, String namespace, String sinkName) {
        final CompletableFuture<SinkConfig> future = new CompletableFuture<SinkConfig>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, future)) {
            return future;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName);
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(SinksImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SinkConfig.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SinksImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SinkStatus getSinkStatus(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            return this.getSinkStatusAsync(tenant, namespace, sinkName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SinkStatus> getSinkStatusAsync(String tenant, String namespace, String sinkName) {
        final CompletableFuture<SinkStatus> future = new CompletableFuture<SinkStatus>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, future)) {
            return future;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path("status");
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(SinksImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SinkStatus.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SinksImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkStatus(String tenant, String namespace, String sinkName, int id) throws PulsarAdminException {
        try {
            return this.getSinkStatusAsync(tenant, namespace, sinkName, id).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<SinkStatus.SinkInstanceStatus.SinkInstanceStatusData> getSinkStatusAsync(String tenant, String namespace, String sinkName, int id) {
        final CompletableFuture<SinkStatus.SinkInstanceStatus.SinkInstanceStatusData> future = new CompletableFuture<SinkStatus.SinkInstanceStatus.SinkInstanceStatusData>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, future)) {
            return future;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(id)).path("status");
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(SinksImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SinkStatus.SinkInstanceStatus.SinkInstanceStatusData.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SinksImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void createSink(SinkConfig sinkConfig, String fileName) throws PulsarAdminException {
        try {
            this.createSinkAsync(sinkConfig, fileName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createSinkAsync(SinkConfig sinkConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(sinkConfig.getTenant(), sinkConfig.getNamespace(), sinkConfig.getName(), future)) {
            return future;
        }
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sinkConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sinkConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.sink, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    public void createSinkWithUrl(SinkConfig sinkConfig, String pkgUrl) throws PulsarAdminException {
        try {
            this.createSinkWithUrlAsync(sinkConfig, pkgUrl).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> createSinkWithUrlAsync(SinkConfig sinkConfig, String pkgUrl) {
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart(new FormDataBodyPart("sinkConfig", (Object)new Gson().toJson(sinkConfig), MediaType.APPLICATION_JSON_TYPE));
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(sinkConfig.getTenant(), sinkConfig.getNamespace(), sinkConfig.getName(), validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName());
        return this.asyncPostRequest(path, Entity.entity(mp, "multipart/form-data"));
    }

    public void deleteSink(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.deleteSinkAsync(cluster, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> deleteSinkAsync(String tenant, String namespace, String function) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, function, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    public void updateSink(SinkConfig sinkConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateSinkAsync(sinkConfig, fileName, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateSinkAsync(SinkConfig sinkConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(sinkConfig.getTenant(), sinkConfig.getNamespace(), sinkConfig.getName(), future)) {
            return future;
        }
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sinkConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sinkConfig), "application/json"));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(options), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.sink, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    public void updateSink(SinkConfig sinkConfig, String fileName) throws PulsarAdminException {
        this.updateSink(sinkConfig, fileName, null);
    }

    public CompletableFuture<Void> updateSinkAsync(SinkConfig sinkConfig, String fileName) {
        return this.updateSinkAsync(sinkConfig, fileName, null);
    }

    public void updateSinkWithUrl(SinkConfig sinkConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateSinkWithUrlAsync(sinkConfig, pkgUrl, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> updateSinkWithUrlAsync(SinkConfig sinkConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(sinkConfig.getTenant(), sinkConfig.getNamespace(), sinkConfig.getName(), future)) {
            return future;
        }
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sinkConfig", (Object)new Gson().toJson(sinkConfig), MediaType.APPLICATION_JSON_TYPE));
            UpdateOptionsImpl options = (UpdateOptionsImpl)updateOptions;
            if (options != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(options), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.sink.path(sinkConfig.getTenant()).path(sinkConfig.getNamespace()).path(sinkConfig.getName());
            return this.asyncPutRequest(path, Entity.entity(mp, "multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
            return future;
        }
    }

    public void updateSinkWithUrl(SinkConfig sinkConfig, String pkgUrl) throws PulsarAdminException {
        this.updateSinkWithUrl(sinkConfig, pkgUrl, null);
    }

    public CompletableFuture<Void> updateSinkWithUrlAsync(SinkConfig sinkConfig, String pkgUrl) {
        return this.updateSinkWithUrlAsync(sinkConfig, pkgUrl, null);
    }

    public void restartSink(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.restartSinkAsync(tenant, namespace, functionName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> restartSinkAsync(String tenant, String namespace, String functionName, int instanceId) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, functionName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void restartSink(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.restartSinkAsync(tenant, namespace, functionName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> restartSinkAsync(String tenant, String namespace, String functionName) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, functionName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(functionName).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void stopSink(String tenant, String namespace, String sinkName, int instanceId) throws PulsarAdminException {
        try {
            this.stopSinkAsync(tenant, namespace, sinkName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> stopSinkAsync(String tenant, String namespace, String sinkName, int instanceId) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void stopSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            this.stopSinkAsync(tenant, namespace, sinkName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> stopSinkAsync(String tenant, String namespace, String sinkName) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void startSink(String tenant, String namespace, String sinkName, int instanceId) throws PulsarAdminException {
        try {
            this.startSinkAsync(tenant, namespace, sinkName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> startSinkAsync(String tenant, String namespace, String sinkName, int instanceId) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void startSink(String tenant, String namespace, String sinkName) throws PulsarAdminException {
        try {
            this.startSinkAsync(tenant, namespace, sinkName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> startSinkAsync(String tenant, String namespace, String sinkName) {
        CompletableFuture<Void> validationFuture = new CompletableFuture<Void>();
        if (!SinksImpl.validateSinkName(tenant, namespace, sinkName, validationFuture)) {
            return validationFuture;
        }
        WebTarget path = this.sink.path(tenant).path(namespace).path(sinkName).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public List<ConnectorDefinition> getBuiltInSinks() throws PulsarAdminException {
        try {
            return this.getBuiltInSinksAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<List<ConnectorDefinition>> getBuiltInSinksAsync() {
        WebTarget path = this.sink.path("builtinsinks");
        final CompletableFuture<List<ConnectorDefinition>> future = new CompletableFuture<List<ConnectorDefinition>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    future.completeExceptionally(SinksImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<ConnectorDefinition>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SinksImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void reloadBuiltInSinks() throws PulsarAdminException {
        try {
            this.reloadBuiltInSinksAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException((Throwable)e);
        }
    }

    public CompletableFuture<Void> reloadBuiltInSinksAsync() {
        WebTarget path = this.sink.path("reloadBuiltInSinks");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    private static boolean validateNamespace(String tenant, String namespace, CompletableFuture<?> future) {
        if (StringUtils.isBlank(tenant)) {
            future.completeExceptionally(new PulsarAdminException("tenant is required"));
            return false;
        }
        if (StringUtils.isBlank(namespace)) {
            future.completeExceptionally(new PulsarAdminException("namespace is required"));
            return false;
        }
        return true;
    }

    private static boolean validateSinkName(String tenant, String namespace, String sinkName, CompletableFuture<?> future) {
        if (!SinksImpl.validateNamespace(tenant, namespace, future)) {
            return false;
        }
        if (StringUtils.isBlank(sinkName)) {
            future.completeExceptionally(new PulsarAdminException("sink name is required"));
            return false;
        }
        return true;
    }
}

