/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.AbstractStructSchema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueSchema<K, V>
extends AbstractSchema<KeyValue<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(KeyValueSchema.class);
    private final Schema<K> keySchema;
    private final Schema<V> valueSchema;
    private final KeyValueEncodingType keyValueEncodingType;
    private SchemaInfo schemaInfo;
    protected SchemaInfoProvider schemaInfoProvider;
    private static final Schema<KeyValue<byte[], byte[]>> KV_BYTES = new KeyValueSchema<byte[], byte[]>(BytesSchema.of(), BytesSchema.of());

    public static <K, V> Schema<KeyValue<K, V>> of(Class<K> key, Class<V> value, SchemaType type) {
        Preconditions.checkArgument(SchemaType.JSON == type || SchemaType.AVRO == type);
        if (SchemaType.JSON == type) {
            return new KeyValueSchema<K, V>(JSONSchema.of(key), JSONSchema.of(value), KeyValueEncodingType.INLINE);
        }
        return new KeyValueSchema<K, V>(AvroSchema.of(key), AvroSchema.of(value), KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema) {
        return new KeyValueSchema<K, V>(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return new KeyValueSchema<K, V>(keySchema, valueSchema, keyValueEncodingType);
    }

    public static Schema<KeyValue<byte[], byte[]>> kvBytes() {
        return KV_BYTES;
    }

    public boolean supportSchemaVersioning() {
        return this.keySchema.supportSchemaVersioning() || this.valueSchema.supportSchemaVersioning();
    }

    private KeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema) {
        this(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    private KeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.keyValueEncodingType = keyValueEncodingType;
        this.schemaInfoProvider = new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return CompletableFuture.completedFuture(KeyValueSchema.this.schemaInfo);
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(KeyValueSchema.this.schemaInfo);
            }

            public String getTopicName() {
                return "key-value-schema";
            }
        };
        if (!this.requireFetchingSchemaInfo()) {
            this.configureKeyValueSchemaInfo();
        } else {
            this.buildKeyValueSchemaInfo();
        }
    }

    public byte[] encode(KeyValue<K, V> message) {
        if (this.keyValueEncodingType != null && this.keyValueEncodingType == KeyValueEncodingType.INLINE) {
            return KeyValue.encode((Object)message.getKey(), this.keySchema, (Object)message.getValue(), this.valueSchema);
        }
        if (message.getValue() == null) {
            return null;
        }
        return this.valueSchema.encode(message.getValue());
    }

    public KeyValue<K, V> decode(byte[] bytes) {
        return this.decode(bytes, null);
    }

    public KeyValue<K, V> decode(byte[] bytes, byte[] schemaVersion) {
        if (this.keyValueEncodingType == KeyValueEncodingType.SEPARATED) {
            throw new SchemaSerializationException("This method cannot be used under this SEPARATED encoding type");
        }
        return KeyValue.decode((byte[])bytes, (keyBytes, valueBytes) -> this.decode(keyBytes, valueBytes, schemaVersion));
    }

    @Override
    public KeyValue<K, V> decode(ByteBuf byteBuf) {
        return this.decode(ByteBufUtil.getBytes(byteBuf));
    }

    @Override
    public KeyValue<K, V> decode(ByteBuf byteBuf, byte[] schemaVersion) {
        return this.decode(ByteBufUtil.getBytes(byteBuf), schemaVersion);
    }

    public KeyValue<K, V> decode(byte[] keyBytes, byte[] valueBytes, byte[] schemaVersion) {
        Object k = keyBytes == null ? null : (this.keySchema.supportSchemaVersioning() && schemaVersion != null ? this.keySchema.decode(keyBytes, schemaVersion) : this.keySchema.decode(keyBytes));
        Object v = valueBytes == null ? null : (this.valueSchema.supportSchemaVersioning() && schemaVersion != null ? this.valueSchema.decode(valueBytes, schemaVersion) : this.valueSchema.decode(valueBytes));
        return new KeyValue(k, v);
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    public boolean requireFetchingSchemaInfo() {
        return this.keySchema.requireFetchingSchemaInfo() || this.valueSchema.requireFetchingSchemaInfo();
    }

    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
        this.keySchema.configureSchemaInfo(topicName, "key", (SchemaInfo)kvSchemaInfo.getKey());
        this.valueSchema.configureSchemaInfo(topicName, "value", (SchemaInfo)kvSchemaInfo.getValue());
        this.configureKeyValueSchemaInfo();
        if (null == this.schemaInfo) {
            throw new RuntimeException("No key schema info or value schema info : key = " + this.keySchema.getSchemaInfo() + ", value = " + this.valueSchema.getSchemaInfo());
        }
    }

    @Override
    public Schema<KeyValue<K, V>> clone() {
        return KeyValueSchema.of(this.keySchema.clone(), this.valueSchema.clone(), this.keyValueEncodingType);
    }

    private void buildKeyValueSchemaInfo() {
        this.schemaInfo = KeyValueSchemaInfo.encodeKeyValueSchemaInfo(this.keySchema, this.valueSchema, this.keyValueEncodingType);
    }

    private void configureKeyValueSchemaInfo() {
        this.buildKeyValueSchemaInfo();
        this.keySchema.setSchemaInfoProvider(new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return KeyValueSchema.this.schemaInfoProvider.getSchemaByVersion(schemaVersion).thenApply(si -> (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(si).getKey());
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(((AbstractStructSchema)((KeyValueSchema)KeyValueSchema.this).keySchema).schemaInfo);
            }

            public String getTopicName() {
                return "key-schema";
            }
        });
        this.valueSchema.setSchemaInfoProvider(new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return KeyValueSchema.this.schemaInfoProvider.getSchemaByVersion(schemaVersion).thenApply(si -> (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(si).getValue());
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(((AbstractStructSchema)((KeyValueSchema)KeyValueSchema.this).valueSchema).schemaInfo);
            }

            public String getTopicName() {
                return "value-schema";
            }
        });
    }

    public String toString() {
        return "KeyValueSchema(" + this.keyValueEncodingType + "," + this.keySchema + "," + this.valueSchema + ")";
    }

    @Override
    public Schema<?> atSchemaVersion(byte[] schemaVersion) throws SchemaSerializationException {
        if (!this.supportSchemaVersioning()) {
            return this;
        }
        Schema<K> keySchema = this.keySchema instanceof AbstractSchema ? ((AbstractSchema)this.keySchema).atSchemaVersion(schemaVersion) : this.keySchema;
        Schema<V> valueSchema = this.valueSchema instanceof AbstractSchema ? ((AbstractSchema)this.valueSchema).atSchemaVersion(schemaVersion) : this.valueSchema;
        return KeyValueSchema.of(keySchema, valueSchema, this.keyValueEncodingType);
    }

    public Schema<K> getKeySchema() {
        return this.keySchema;
    }

    public Schema<V> getValueSchema() {
        return this.valueSchema;
    }

    public KeyValueEncodingType getKeyValueEncodingType() {
        return this.keyValueEncodingType;
    }
}

