/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.shade.com.google.common.base.Objects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

@ApiModel(value="NamespaceIsolationData", description="The data of namespace isolation configuration")
public class NamespaceIsolationData {
    @ApiModelProperty(name="namespaces", value="The list of namespaces to apply this namespace isolation data")
    public List<String> namespaces = new ArrayList<String>();
    @ApiModelProperty(name="primary", value="The list of primary brokers for serving the list of namespaces in this isolation policy")
    public List<String> primary = new ArrayList<String>();
    @ApiModelProperty(name="primary", value="The list of secondary brokers for serving the list of namespaces in this isolation policy")
    public List<String> secondary = new ArrayList<String>();
    @ApiModelProperty(name="auto_failover_policy", value="The data of auto-failover policy configuration", example="{  \"policy_type\": \"min_available\"  \"parameters\": {    \"\": \"\"  }}")
    public AutoFailoverPolicyData auto_failover_policy;

    public int hashCode() {
        return Objects.hashCode(this.namespaces, this.primary, this.secondary, this.auto_failover_policy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceIsolationData) {
            NamespaceIsolationData other = (NamespaceIsolationData)obj;
            return Objects.equal(this.namespaces, other.namespaces) && Objects.equal(this.primary, other.primary) && Objects.equal(this.secondary, other.secondary) && Objects.equal(this.auto_failover_policy, other.auto_failover_policy);
        }
        return false;
    }

    public void validate() {
        Preconditions.checkArgument(this.namespaces != null && !this.namespaces.isEmpty() && this.primary != null && !this.primary.isEmpty() && this.validateRegex(this.primary) && this.secondary != null && this.validateRegex(this.secondary) && this.auto_failover_policy != null);
        this.auto_failover_policy.validate();
    }

    private boolean validateRegex(List<String> policies) {
        if (policies != null && !policies.isEmpty()) {
            policies.forEach(policy -> {
                try {
                    if (StringUtils.isNotBlank(policy)) {
                        Pattern.compile(policy);
                    }
                }
                catch (PatternSyntaxException exception) {
                    throw new IllegalArgumentException("invalid policy regex " + policy);
                }
            });
        }
        return true;
    }

    public String toString() {
        return String.format("namespaces=%s primary=%s secondary=%s auto_failover_policy=%s", this.namespaces, this.primary, this.secondary, this.auto_failover_policy);
    }
}

